package ru.ivk1800.riflesso

import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension
import org.jetbrains.kotlin.compiler.plugin.CompilerPluginRegistrar
import org.jetbrains.kotlin.compiler.plugin.ExperimentalCompilerApi
import org.jetbrains.kotlin.config.CompilerConfiguration

@OptIn(ExperimentalCompilerApi::class)
class RiflessoComponentRegistrar : CompilerPluginRegistrar() {
    override val supportsK2 = true

    override fun ExtensionStorage.registerExtensions(configuration: CompilerConfiguration) {
        val isEnabled = configuration.get(PluginKeys.IS_ENABLED) ?: true

        if (isEnabled) {
            IrGenerationExtension.registerExtension(RiflessoIrGenerationExtension())
        }
    }
}
