/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq;

import com.rabbitmq.client.QueueingConsumer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Message {
    public static final Message NONE = new None();
    private final byte[] body;

    public Message(byte[] body) {
        this.body = body;
    }

    public static Message forDelivery(QueueingConsumer.Delivery delivery) {
        return delivery != null ? new DeliveredMessage(delivery) : NONE;
    }

    public static Message forSending(byte[] body, Map<String, Object> headers, String exchangeName, String routingKey, String contentType, String contentEncoding, boolean persistent) {
        return body != null && exchangeName != null && exchangeName.length() > 0 ? new MessageForSending(body, headers, exchangeName, routingKey, contentType, contentEncoding, persistent) : NONE;
    }

    public byte[] getBody() {
        return this.body;
    }

    public static class MessageForSending
    extends Message {
        private final Map<String, Object> headers;
        private final String exchangeName;
        private final String routingKey;
        private final String contentType;
        private final String contentEncoding;
        private final boolean persistent;

        private MessageForSending(byte[] body, Map<String, Object> headers, String exchangeName, String routingKey, String contentType, String contentEncoding, boolean persistent) {
            super(body);
            this.headers = headers != null ? headers : new HashMap();
            this.exchangeName = exchangeName;
            this.routingKey = routingKey;
            this.contentType = contentType;
            this.contentEncoding = contentEncoding;
            this.persistent = persistent;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public String getExchangeName() {
            return this.exchangeName;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getContentEncoding() {
            return this.contentEncoding;
        }

        public boolean isPersistent() {
            return this.persistent;
        }
    }

    public static class None
    extends Message {
        private None() {
            super(null);
        }

        @Override
        public byte[] getBody() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DeliveredMessage
    extends Message {
        private final boolean redelivery;
        private final long deliveryTag;
        private final String routingKey;
        private final String exchange;
        private final String className;
        private final String clusterId;
        private final String contentEncoding;
        private final String contentType;
        private final String correlationId;
        private final Integer deliveryMode;
        private final String expiration;
        private final Map<String, Object> headers;
        private final String messageId;
        private final Integer priority;
        private final String replyTo;
        private final Date timestamp;
        private final String type;
        private final String userId;

        public DeliveredMessage(QueueingConsumer.Delivery delivery) {
            super(delivery.getBody());
            this.redelivery = delivery.getEnvelope().isRedeliver();
            this.deliveryTag = delivery.getEnvelope().getDeliveryTag();
            this.routingKey = delivery.getEnvelope().getRoutingKey();
            this.exchange = delivery.getEnvelope().getExchange();
            this.className = delivery.getProperties().getClassName();
            this.clusterId = delivery.getProperties().getClusterId();
            this.contentEncoding = delivery.getProperties().getContentEncoding();
            this.contentType = delivery.getProperties().getContentType();
            this.correlationId = delivery.getProperties().getCorrelationId();
            this.deliveryMode = delivery.getProperties().getDeliveryMode();
            this.expiration = delivery.getProperties().getExpiration();
            this.headers = delivery.getProperties().getHeaders();
            this.messageId = delivery.getProperties().getMessageId();
            this.priority = delivery.getProperties().getPriority();
            this.replyTo = delivery.getProperties().getReplyTo();
            this.timestamp = delivery.getProperties().getTimestamp();
            this.type = delivery.getProperties().getType();
            this.userId = delivery.getProperties().getUserId();
        }

        public boolean isRedelivery() {
            return this.redelivery;
        }

        public long getDeliveryTag() {
            return this.deliveryTag;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }

        public String getExchange() {
            return this.exchange;
        }

        public String getClassName() {
            return this.className;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public String getContentEncoding() {
            return this.contentEncoding;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }

        public Integer getDeliveryMode() {
            return this.deliveryMode;
        }

        public String getExpiration() {
            return this.expiration;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public String getReplyTo() {
            return this.replyTo;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public String getType() {
            return this.type;
        }

        public String getUserId() {
            return this.userId;
        }
    }
}

