/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq;

import backtype.storm.spout.Scheme;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import java.util.List;
import java.util.Map;
import ru.kiryam.storm.rabbitmq.Message;

public interface MessageScheme
extends Scheme {
    public void open(Map var1, TopologyContext var2);

    public void close();

    public List<Object> deserialize(Message var1);

    public static class Builder {
        public static MessageScheme from(Scheme scheme) {
            if (scheme instanceof MessageScheme) {
                return (MessageScheme)scheme;
            }
            return Builder.create(scheme);
        }

        private static MessageScheme create(final Scheme scheme) {
            return new MessageScheme(){

                @Override
                public void open(Map config, TopologyContext context) {
                }

                @Override
                public void close() {
                }

                @Override
                public List<Object> deserialize(Message message) {
                    return scheme.deserialize(message.getBody());
                }

                public List<Object> deserialize(byte[] bytes) {
                    return scheme.deserialize(bytes);
                }

                public Fields getOutputFields() {
                    return scheme.getOutputFields();
                }
            };
        }
    }
}

