/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq;

import backtype.storm.spout.Scheme;
import backtype.storm.spout.SpoutOutputCollector;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import java.util.List;
import ru.kiryam.storm.rabbitmq.Declarator;
import ru.kiryam.storm.rabbitmq.Message;
import ru.kiryam.storm.rabbitmq.MultiStreamSplitter;
import ru.kiryam.storm.rabbitmq.RabbitMQSpout;

public class MultiStreamSpout
extends RabbitMQSpout {
    private final MultiStreamSplitter streamSplitter;
    private final Fields outputFields;

    public MultiStreamSpout(Scheme scheme, MultiStreamSplitter streamSplitter) {
        super(scheme);
        this.outputFields = scheme.getOutputFields();
        this.streamSplitter = streamSplitter;
    }

    public MultiStreamSpout(Scheme scheme, MultiStreamSplitter streamSplitter, Declarator declarator) {
        super(scheme, declarator);
        this.outputFields = scheme.getOutputFields();
        this.streamSplitter = streamSplitter;
    }

    @Override
    protected List<Integer> emit(List<Object> tuple, Message message, SpoutOutputCollector spoutOutputCollector) {
        String stream = this.streamSplitter.selectStream(tuple, message);
        return spoutOutputCollector.emit(stream, tuple, (Object)this.getDeliveryTag(message));
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer outputFieldsDeclarer) {
        for (String stream : this.streamSplitter.streamNames()) {
            outputFieldsDeclarer.declareStream(stream, this.outputFields);
        }
    }
}

