/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Tuple;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.kiryam.storm.rabbitmq.Declarator;
import ru.kiryam.storm.rabbitmq.RabbitMQProducer;
import ru.kiryam.storm.rabbitmq.TupleToMessage;

public class RabbitMQBolt
extends BaseRichBolt {
    private static final long serialVersionUID = 97236452008970L;
    private final TupleToMessage scheme;
    private final Declarator declarator;
    private transient Logger logger;
    private transient RabbitMQProducer producer;
    private transient OutputCollector collector;

    public RabbitMQBolt(TupleToMessage scheme) {
        this(scheme, new Declarator.NoOp());
    }

    public RabbitMQBolt(TupleToMessage scheme, Declarator declarator) {
        this.scheme = scheme;
        this.declarator = declarator;
    }

    public void prepare(Map stormConf, TopologyContext context, OutputCollector collector) {
        this.producer = new RabbitMQProducer(this.declarator);
        this.producer.open(stormConf);
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.collector = collector;
        this.scheme.prepare(stormConf);
        this.logger.info("Successfully prepared RabbitMQBolt");
    }

    public void execute(Tuple tuple) {
        this.publish(tuple);
        this.acknowledge(tuple);
    }

    protected void acknowledge(Tuple tuple) {
        this.collector.ack(tuple);
    }

    protected void publish(Tuple tuple) {
        this.producer.send(this.scheme.produceMessage(tuple));
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

