/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq;

import backtype.storm.spout.Scheme;
import backtype.storm.task.TopologyContext;
import backtype.storm.tuple.Fields;
import com.rabbitmq.client.LongString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.kiryam.storm.rabbitmq.Message;
import ru.kiryam.storm.rabbitmq.MessageScheme;

public class RabbitMQMessageScheme
implements MessageScheme {
    private final Scheme payloadScheme;
    private final List<String> fieldNames;

    public RabbitMQMessageScheme(Scheme payloadScheme, String envelopeFieldName, String propertiesFieldName) {
        this.payloadScheme = payloadScheme;
        List payloadFieldNames = payloadScheme.getOutputFields().toList();
        this.fieldNames = new ArrayList<String>();
        this.fieldNames.addAll(payloadFieldNames);
        this.fieldNames.add(envelopeFieldName);
        this.fieldNames.add(propertiesFieldName);
    }

    @Override
    public void open(Map config, TopologyContext context) {
    }

    @Override
    public void close() {
    }

    @Override
    public List<Object> deserialize(Message message) {
        Message.DeliveredMessage dm = (Message.DeliveredMessage)message;
        Envelope envelope = this.createEnvelope(dm);
        Properties properties = this.createProperties(dm);
        List<Object> payloadValues = this.deserialize(dm.getBody());
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(payloadValues);
        values.add(envelope);
        values.add(properties);
        return values;
    }

    public List<Object> deserialize(byte[] payload) {
        return this.payloadScheme.deserialize(payload);
    }

    public Fields getOutputFields() {
        return new Fields(this.fieldNames);
    }

    private Envelope createEnvelope(Message.DeliveredMessage dm) {
        return new Envelope(dm.isRedelivery(), dm.getDeliveryTag(), dm.getExchange(), dm.getRoutingKey());
    }

    private Properties createProperties(Message.DeliveredMessage dm) {
        return new Properties(dm.getClassName(), dm.getClusterId(), dm.getContentEncoding(), dm.getContentType(), dm.getCorrelationId(), dm.getDeliveryMode(), dm.getExpiration(), this.serializableHeaders(dm.getHeaders()), dm.getMessageId(), dm.getPriority(), dm.getReplyTo(), dm.getTimestamp(), dm.getType(), dm.getUserId());
    }

    private Map<String, Object> serializableHeaders(Map<String, Object> headers) {
        if (headers == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> headersSerializable = new HashMap<String, Object>(headers.size());
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (entry.getValue() instanceof Number || entry.getValue() instanceof Boolean || entry.getValue() instanceof Character || entry.getValue() instanceof String || entry.getValue() instanceof Date) {
                headersSerializable.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof LongString) {
                headersSerializable.put(entry.getKey(), entry.getValue().toString());
                continue;
            }
            if (!(entry.getValue() instanceof ArrayList)) continue;
            ArrayList<Map<String, Object>> serializedList = new ArrayList<Map<String, Object>>();
            for (Object elm : (ArrayList)entry.getValue()) {
                if (!(elm instanceof HashMap)) continue;
                serializedList.add(this.serializableHeaders((HashMap)elm));
            }
            headersSerializable.put(entry.getKey(), serializedList);
        }
        return headersSerializable;
    }

    public static class Properties
    implements Serializable {
        private final String className;
        private final String clusterId;
        private final String contentEncoding;
        private final String contentType;
        private final String correlationId;
        private final Integer deliveryMode;
        private final String expiration;
        private final Map<String, Object> headers;
        private final String messageId;
        private final Integer priority;
        private final String replyTo;
        private final Date timestamp;
        private final String type;
        private final String userId;

        public Properties(String className, String clusterId, String contentEncoding, String contentType, String correlationId, Integer deliveryMode, String expiration, Map<String, Object> headers, String messageId, Integer priority, String replyTo, Date timestamp, String type, String userId) {
            this.className = className;
            this.clusterId = clusterId;
            this.contentEncoding = contentEncoding;
            this.contentType = contentType;
            this.correlationId = correlationId;
            this.deliveryMode = deliveryMode;
            this.expiration = expiration;
            this.headers = headers;
            this.messageId = messageId;
            this.priority = priority;
            this.replyTo = replyTo;
            this.timestamp = timestamp;
            this.type = type;
            this.userId = userId;
        }

        public String getClassName() {
            return this.className;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public String getContentEncoding() {
            return this.contentEncoding;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getCorrelationId() {
            return this.correlationId;
        }

        public Integer getDeliveryMode() {
            return this.deliveryMode;
        }

        public String getExpiration() {
            return this.expiration;
        }

        public Map<String, Object> getHeaders() {
            return this.headers;
        }

        public String getMessageId() {
            return this.messageId;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public String getReplyTo() {
            return this.replyTo;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public String getType() {
            return this.type;
        }

        public String getUserId() {
            return this.userId;
        }
    }

    public static class Envelope
    implements Serializable {
        private final boolean isRedelivery;
        private final long deliveryTag;
        private final String exchange;
        private final String routingKey;

        public Envelope(boolean isRedelivery, long deliveryTag, String exchange, String routingKey) {
            this.isRedelivery = isRedelivery;
            this.deliveryTag = deliveryTag;
            this.exchange = exchange;
            this.routingKey = routingKey;
        }

        public boolean isRedelivery() {
            return this.isRedelivery;
        }

        public long getDeliveryTag() {
            return this.deliveryTag;
        }

        public String getExchange() {
            return this.exchange;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }
    }
}

