/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ru.kiryam.storm.rabbitmq.Message;
import ru.kiryam.storm.rabbitmq.MultiStreamSplitter;

public class RedeliveryStreamSeparator
implements MultiStreamSplitter {
    public static final String INITIAL_DELIVERY_STREAM = "initial_delivery";
    public static final String REDELIVERY_STREAM = "redelivery";
    private static final List<String> streams = Collections.unmodifiableList(Arrays.asList("initial_delivery", "redelivery"));

    @Override
    public List<String> streamNames() {
        return streams;
    }

    @Override
    public String selectStream(List<Object> tuple, Message message) {
        Message.DeliveredMessage deliveredMessage = (Message.DeliveredMessage)message;
        return deliveredMessage.isRedelivery() ? REDELIVERY_STREAM : INITIAL_DELIVERY_STREAM;
    }
}

