/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq.config;

import com.rabbitmq.client.Address;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public class ConfigAvailableHosts
implements Serializable {
    private static final long serialVersionUID = -7444594758428554141L;
    private static final String HOST_DELIMINITER = "|";
    private final Map<String, Integer> hostsMap = new TreeMap<String, Integer>();

    public Map<String, Integer> getHostsMap() {
        return this.hostsMap;
    }

    public boolean isEmpty() {
        return this.hostsMap.isEmpty();
    }

    public Address[] toAddresses() {
        Address[] addresses = new Address[this.hostsMap.size()];
        int i = 0;
        for (Map.Entry<String, Integer> entry : this.hostsMap.entrySet()) {
            if (entry.getKey() == null) continue;
            addresses[i++] = entry.getValue() == null ? new Address(entry.getKey()) : new Address(entry.getKey(), entry.getValue().intValue());
        }
        return addresses;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String host : this.hostsMap.keySet()) {
            Integer port = this.hostsMap.get(host);
            if (!first) {
                builder.append(HOST_DELIMINITER);
            } else {
                first = false;
            }
            builder.append(host);
            builder.append(port != null ? ":" + port : "");
        }
        return builder.toString();
    }

    public static ConfigAvailableHosts fromString(String serialzed) {
        String[] hosts;
        ConfigAvailableHosts value = new ConfigAvailableHosts();
        for (String host : hosts = serialzed.split("[|]")) {
            if (host.isEmpty()) continue;
            String[] brokenUp = host.split(":");
            value.getHostsMap().put(brokenUp[0], brokenUp.length == 2 ? Integer.valueOf(Integer.parseInt(brokenUp[1])) : null);
        }
        return value;
    }
}

