/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq.config;

import com.rabbitmq.client.ConnectionFactory;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import ru.kiryam.storm.rabbitmq.config.ConfigAvailableHosts;
import ru.kiryam.storm.rabbitmq.config.ConfigUtils;

public class ConnectionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String host;
    private int port;
    private String username;
    private String password;
    private String virtualHost;
    private int heartBeat;
    private boolean ssl;
    private ConfigAvailableHosts highAvailabilityHosts = new ConfigAvailableHosts();
    private String uri;

    public static ConnectionConfig forTest() {
        return new ConnectionConfig("localhost", "guest", "guest");
    }

    public ConnectionConfig(String uri) {
        this.uri = uri;
    }

    public ConnectionConfig(String host, String username, String password) {
        this(host, 5672, username, password, "/", 10, false);
    }

    public ConnectionConfig(String host, String username, String password, boolean ssl) {
        this(host, 5672, username, password, "/", 10, ssl);
    }

    public ConnectionConfig(String host, int port, String username, String password, String virtualHost, int heartBeat) {
        this(host, port, username, password, virtualHost, heartBeat, false);
    }

    public ConnectionConfig(String host, int port, String username, String password, String virtualHost, int heartBeat, boolean ssl) {
        this(new ConfigAvailableHosts(), host, port, username, password, virtualHost, heartBeat, ssl);
    }

    public ConnectionConfig(ConfigAvailableHosts hosts, String host, int port, String username, String password, String virtualHost, int heartBeat, boolean ssl) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.virtualHost = virtualHost;
        this.heartBeat = heartBeat;
        this.ssl = ssl;
        this.highAvailabilityHosts = hosts;
    }

    public ConfigAvailableHosts getHighAvailabilityHosts() {
        return this.highAvailabilityHosts;
    }

    public void setHighAvailabilityHosts(ConfigAvailableHosts highAvailabilityHosts) {
        this.highAvailabilityHosts = highAvailabilityHosts;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public int getHeartBeat() {
        return this.heartBeat;
    }

    public String getUri() {
        return this.uri;
    }

    boolean isSsl() {
        return this.ssl;
    }

    public ConnectionFactory asConnectionFactory() {
        ConnectionFactory factory = new ConnectionFactory();
        if (this.uri != null) {
            try {
                factory.setUri(this.uri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
        }
        factory.setHost(this.host);
        factory.setPort(this.port);
        factory.setUsername(this.username);
        factory.setPassword(this.password);
        factory.setVirtualHost(this.virtualHost);
        factory.setRequestedHeartbeat(this.heartBeat);
        if (this.ssl) {
            try {
                factory.useSslProtocol();
            }
            catch (KeyManagementException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return factory;
    }

    public static ConnectionConfig getFromStormConfig(Map<String, Object> stormConfig) {
        if (stormConfig.containsKey("rabbitmq.uri")) {
            return new ConnectionConfig(ConfigUtils.getFromMap("rabbitmq.uri", stormConfig));
        }
        String highAvailabilityHostsString = ConfigUtils.getFromMap("rabbitmq.ha.hosts", stormConfig);
        if (highAvailabilityHostsString != null) {
            ConfigAvailableHosts haHosts = ConfigAvailableHosts.fromString(highAvailabilityHostsString);
            return new ConnectionConfig(haHosts, ConfigUtils.getFromMap("rabbitmq.host", stormConfig, "localhost"), ConfigUtils.getFromMapAsInt("rabbitmq.port", stormConfig, 5672), ConfigUtils.getFromMap("rabbitmq.username", stormConfig, "guest"), ConfigUtils.getFromMap("rabbitmq.password", stormConfig, "guest"), ConfigUtils.getFromMap("rabbitmq.virtualhost", stormConfig, "/"), ConfigUtils.getFromMapAsInt("rabbitmq.heartbeat", stormConfig, 0), ConfigUtils.getFromMapAsBoolean("rabbitmq.ssl", stormConfig, false));
        }
        return new ConnectionConfig(ConfigUtils.getFromMap("rabbitmq.host", stormConfig, "localhost"), ConfigUtils.getFromMapAsInt("rabbitmq.port", stormConfig, 5672), ConfigUtils.getFromMap("rabbitmq.username", stormConfig, "guest"), ConfigUtils.getFromMap("rabbitmq.password", stormConfig, "guest"), ConfigUtils.getFromMap("rabbitmq.virtualhost", stormConfig, "/"), ConfigUtils.getFromMapAsInt("rabbitmq.heartbeat", stormConfig, 0), ConfigUtils.getFromMapAsBoolean("rabbitmq.ssl", stormConfig, false));
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.uri != null) {
            ConfigUtils.addToMap("rabbitmq.uri", map, this.uri);
        } else {
            ConfigUtils.addToMap("rabbitmq.host", map, this.host);
            ConfigUtils.addToMap("rabbitmq.port", map, this.port);
            ConfigUtils.addToMap("rabbitmq.username", map, this.username);
            ConfigUtils.addToMap("rabbitmq.password", map, this.password);
            ConfigUtils.addToMap("rabbitmq.virtualhost", map, this.virtualHost);
            ConfigUtils.addToMap("rabbitmq.heartbeat", map, this.heartBeat);
            ConfigUtils.addToMap("rabbitmq.ssl", map, this.ssl);
            ConfigUtils.addToMap("rabbitmq.ha.hosts", map, this.highAvailabilityHosts.toString());
        }
        return map;
    }
}

