/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import ru.kiryam.storm.rabbitmq.config.ConfigUtils;
import ru.kiryam.storm.rabbitmq.config.ConnectionConfig;

public class ConsumerConfig
implements Serializable {
    private final ConnectionConfig connectionConfig;
    private final int prefetchCount;
    private final String queueName;
    private final boolean requeueOnFail;

    public ConsumerConfig(ConnectionConfig connectionConfig, int prefetchCount, String queueName, boolean requeueOnFail) {
        if (connectionConfig == null || prefetchCount < 1) {
            throw new IllegalArgumentException("Invalid configuration");
        }
        this.connectionConfig = connectionConfig;
        this.prefetchCount = prefetchCount;
        this.queueName = queueName;
        this.requeueOnFail = requeueOnFail;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public boolean isRequeueOnFail() {
        return this.requeueOnFail;
    }

    public static ConsumerConfig getFromStormConfig(Map<String, Object> stormConfig) {
        ConnectionConfig connectionConfig = ConnectionConfig.getFromStormConfig(stormConfig);
        return new ConsumerConfig(connectionConfig, ConfigUtils.getFromMapAsInt("rabbitmq.prefetchCount", stormConfig), ConfigUtils.getFromMap("rabbitmq.queueName", stormConfig), ConfigUtils.getFromMapAsBoolean("rabbitmq.requeueOnFail", stormConfig));
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.connectionConfig.asMap());
        ConfigUtils.addToMap("rabbitmq.prefetchCount", map, this.prefetchCount);
        ConfigUtils.addToMap("rabbitmq.queueName", map, this.queueName);
        ConfigUtils.addToMap("rabbitmq.requeueOnFail", map, this.requeueOnFail);
        return map;
    }
}

