/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq.config;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import ru.kiryam.storm.rabbitmq.config.ConfigUtils;
import ru.kiryam.storm.rabbitmq.config.ConnectionConfig;

public class ProducerConfig
implements Serializable {
    private final ConnectionConfig connectionConfig;
    private final String exchangeName;
    private final String routingKey;
    private final String contentType;
    private final String contentEncoding;
    private final boolean persistent;

    public ProducerConfig(ConnectionConfig connectionConfig, String exchangeName, String routingKey, String contentType, String contentEncoding, boolean persistent) {
        this.connectionConfig = connectionConfig;
        this.exchangeName = exchangeName;
        this.routingKey = routingKey;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.persistent = persistent;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    public String getExchangeName() {
        return this.exchangeName;
    }

    public String getRoutingKey() {
        return this.routingKey;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public static ProducerConfig getFromStormConfig(Map<String, Object> stormConfig) {
        ConnectionConfig connectionConfig = ConnectionConfig.getFromStormConfig(stormConfig);
        return new ProducerConfig(connectionConfig, ConfigUtils.getFromMap("rabbitmq.exchangeName", stormConfig), ConfigUtils.getFromMap("rabbitmq.routingKey", stormConfig), ConfigUtils.getFromMap("rabbitmq.contentType", stormConfig), ConfigUtils.getFromMap("rabbitmq.contentEncoding", stormConfig), ConfigUtils.getFromMapAsBoolean("rabbitmq.persistent", stormConfig));
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.connectionConfig.asMap());
        ConfigUtils.addToMap("rabbitmq.exchangeName", map, this.exchangeName);
        ConfigUtils.addToMap("rabbitmq.routingKey", map, this.routingKey);
        ConfigUtils.addToMap("rabbitmq.contentType", map, this.contentType);
        ConfigUtils.addToMap("rabbitmq.contentEncoding", map, this.contentEncoding);
        ConfigUtils.addToMap("rabbitmq.persistent", map, this.persistent);
        return map;
    }
}

