/*
 * Decompiled with CFR 0.152.
 */
package ru.kiryam.storm.rabbitmq.config;

import ru.kiryam.storm.rabbitmq.config.ConnectionConfig;
import ru.kiryam.storm.rabbitmq.config.ProducerConfig;

public class ProducerConfigBuilder {
    private ConnectionConfig connectionConfig;
    private String exchangeName;
    private String routingKey;
    private String contentType;
    private String contentEncoding;
    private boolean persistent = false;

    public ProducerConfigBuilder connection(ConnectionConfig connection) {
        this.connectionConfig = connection;
        return this;
    }

    public ProducerConfigBuilder exchange(String exchange) {
        this.exchangeName = exchange;
        return this;
    }

    public ProducerConfigBuilder routingKey(String routingKey) {
        this.routingKey = routingKey;
        return this;
    }

    public ProducerConfigBuilder contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public ProducerConfigBuilder contentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public ProducerConfigBuilder persistent() {
        this.persistent = true;
        return this;
    }

    public ProducerConfig build() {
        return new ProducerConfig(this.connectionConfig, this.exchangeName, this.routingKey, this.contentType, this.contentEncoding, this.persistent);
    }
}

