/*
 * Decompiled with CFR 0.152.
 */
package ru.lagoshny;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

abstract class AbstractDockerComposeCommandMojo
extends AbstractMojo {
    @Parameter(defaultValue="false")
    protected boolean detachedMode;
    @Parameter
    private String dockerComposeFile;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="false")
    boolean skip;
    @Parameter
    private String applicationName;
    @Parameter
    private String projectDir;
    @Parameter
    protected String containerName;

    AbstractDockerComposeCommandMojo() {
    }

    void execute(List<String> args) throws MojoExecutionException, MojoFailureException {
        if (StringUtils.isNotEmpty((CharSequence)this.containerName)) {
            args.add(this.containerName);
        }
        List<String> cmdCommand = this.buildCmdCommand(args);
        ProcessBuilder processBuilder = new ProcessBuilder(cmdCommand).inheritIO();
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                this.getLog().info((CharSequence)line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException(IOUtils.toString((InputStream)process.getErrorStream(), (Charset)Charset.forName("UTF-8")));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private List<String> buildCmdCommand(List<String> args) {
        String composeFilePath;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("docker-compose");
        if (StringUtils.isNotEmpty((CharSequence)this.dockerComposeFile) && StringUtils.isNotEmpty((CharSequence)(composeFilePath = Paths.get(this.dockerComposeFile, new String[0]).toString()))) {
            cmd.add("-f");
            cmd.add(composeFilePath);
        }
        if (this.verbose) {
            cmd.add("--verbose");
        }
        cmd.addAll(args);
        return cmd;
    }

    public boolean isDetachedMode() {
        return this.detachedMode;
    }

    public String getDockerComposeFile() {
        return this.dockerComposeFile;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    public String getContainerName() {
        return this.containerName;
    }
}

