/*
 * Decompiled with CFR 0.152.
 */
package ru.lagoshny;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

abstract class AbstractDockerComposeCommandMojo
extends AbstractMojo {
    private static final String DEFAULT_PROJECT_NAME = "default";
    @Parameter(defaultValue="false")
    protected boolean detachedMode;
    @Parameter
    private String[] dockerComposeFiles;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="false")
    boolean skip;
    @Parameter
    private String applicationName;
    @Parameter
    private String projectDir;
    @Parameter
    protected String serviceName;
    @Parameter
    private String projectName;
    @Parameter
    private Map<String, String> environmentVariables;

    AbstractDockerComposeCommandMojo() {
    }

    void execute(List<String> args) throws MojoExecutionException {
        if (StringUtils.isNotEmpty((CharSequence)this.serviceName)) {
            args.add(this.serviceName);
        }
        List<String> cmdCommand = this.buildCmdCommand(args);
        ProcessBuilder processBuilder = new ProcessBuilder(cmdCommand).inheritIO();
        if (this.environmentVariables != null) {
            processBuilder.environment().putAll(this.environmentVariables);
        }
        try {
            String line;
            Process process = processBuilder.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = br.readLine()) != null) {
                this.getLog().info((CharSequence)line);
            }
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException(IOUtils.toString((InputStream)process.getErrorStream(), (Charset)Charset.forName("UTF-8")));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private List<String> buildCmdCommand(List<String> args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("docker-compose");
        if (this.dockerComposeFiles != null && this.dockerComposeFiles.length > 0) {
            for (String composeFile : this.dockerComposeFiles) {
                String composeFilePath = Paths.get(composeFile, new String[0]).toString();
                if (!StringUtils.isNotEmpty((CharSequence)composeFilePath)) continue;
                this.getLog().debug((CharSequence)String.format("Running with custom location docker-compose file: %s", composeFilePath));
                cmd.add("-f");
                cmd.add(composeFilePath);
            }
        }
        String projectNameParam = StringUtils.isNotBlank((CharSequence)this.projectName) ? this.projectName : DEFAULT_PROJECT_NAME;
        cmd.add("-p");
        cmd.add(projectNameParam);
        this.getLog().debug((CharSequence)String.format("Use project name %s", projectNameParam));
        if (this.verbose) {
            this.getLog().debug((CharSequence)"Running with --verbose flag");
            cmd.add("--verbose");
        }
        cmd.addAll(args);
        this.getLog().debug((CharSequence)((Object)cmd).toString());
        return cmd;
    }

    public boolean isDetachedMode() {
        return this.detachedMode;
    }

    public String[] getDockerComposeFiles() {
        return this.dockerComposeFiles;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

