/*
 * Decompiled with CFR 0.152.
 */
package ru.lagoshny;

import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import ru.lagoshny.AbstractDockerComposeCommandMojo;
import ru.lagoshny.constants.DockerComposeCommand;

@Mojo(name="up", threadSafe=true)
public class DockerComposeCommandUpMojo
extends AbstractDockerComposeCommandMojo {
    @Parameter(defaultValue="false")
    private boolean needBuild;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)String.format("Skip execution %s command for service: %s", new Object[]{DockerComposeCommand.UP, this.serviceName}));
            return;
        }
        StringBuilder logBuilder = new StringBuilder(String.format("Running %s command for %s service", new Object[]{DockerComposeCommand.UP, this.serviceName}));
        ArrayList<String> args = new ArrayList<String>();
        args.add(DockerComposeCommand.UP.getValue());
        if (this.detachedMode) {
            args.add("-d");
            logBuilder.append(", in detached mode");
        }
        if (this.needBuild) {
            args.add("--build");
            logBuilder.append(", in build mode");
        }
        this.getLog().info((CharSequence)logBuilder.toString());
        super.execute(args);
    }

    public boolean isNeedBuild() {
        return this.needBuild;
    }
}

