/*
 * Decompiled with CFR 0.152.
 */
package ru.dadata.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.dadata.api.entity.Address;
import ru.dadata.api.entity.Birthdate;
import ru.dadata.api.entity.Email;
import ru.dadata.api.entity.Name;
import ru.dadata.api.entity.Passport;
import ru.dadata.api.entity.Phone;
import ru.dadata.api.entity.Vehicle;

public class DaData {
    private static final String API_VERSION = "v2";
    private static final String API_URL = "https://dadata.ru/api";
    private static final String REQUEST_METHOD_GET = "GET";
    private static final String REQUEST_METHOD_POST = "POST";
    private static final Logger LOGGER = LogManager.getLogger();
    private final String authKey;
    private final String authSecret;
    private Gson gson = new GsonBuilder().create();

    public DaData(String key, String secret) {
        this.authKey = key;
        this.authSecret = secret;
    }

    public double getBalance() {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonElement = jsonParser.parse(this.fetchJson("profile/balance", REQUEST_METHOD_GET, new String[0]));
        return jsonElement.getAsJsonObject().get("balance").getAsDouble();
    }

    public Address cleanAddress(String source) {
        return this.cleanAddresses(source)[0];
    }

    public Address[] cleanAddresses(String ... sources) {
        return this.populate(Address[].class, "clean/address", sources);
    }

    public Phone cleanPhone(String source) {
        return this.cleanPhones(source)[0];
    }

    public Phone[] cleanPhones(String ... sources) {
        return this.populate(Phone[].class, "clean/phone", sources);
    }

    public Passport cleanPassport(String source) {
        return this.cleanPassports(source)[0];
    }

    public Passport[] cleanPassports(String ... sources) {
        return this.populate(Passport[].class, "clean/passport", sources);
    }

    public Name cleanName(String source) {
        return this.cleanNames(source)[0];
    }

    public Name[] cleanNames(String ... sources) {
        return this.populate(Name[].class, "clean/name", sources);
    }

    public Email cleanEmail(String source) {
        return this.cleanEmails(source)[0];
    }

    public Email[] cleanEmails(String ... sources) {
        return this.populate(Email[].class, "clean/email", sources);
    }

    public Birthdate cleanBirthdate(String source) {
        return this.cleanBirthdates(source)[0];
    }

    public Birthdate[] cleanBirthdates(String ... sources) {
        return this.populate(Birthdate[].class, "clean/birthdate", sources);
    }

    public Vehicle cleanVehicle(String source) {
        return this.cleanVehicles(source)[0];
    }

    public Vehicle[] cleanVehicles(String ... sources) {
        return this.populate(Vehicle[].class, "clean/vehicle", sources);
    }

    private <T> T populate(Class<T> tClass, String method, String ... sources) {
        return (T)this.gson.fromJson(this.fetchJson(method, REQUEST_METHOD_POST, sources), tClass);
    }

    private String fetchJson(String method, String requestMethod, String ... sources) {
        String toReturn = null;
        try {
            URL url = new URL("https://dadata.ru/api/v2/" + method);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(requestMethod);
            connection.addRequestProperty("Content-Type", "application/json");
            connection.addRequestProperty("Authorization", "Token " + this.authKey);
            connection.addRequestProperty("X-Secret", this.authSecret);
            if (sources.length > 0) {
                connection.setDoOutput(true);
                OutputStream outputStream = connection.getOutputStream();
                outputStream.write(this.gson.toJson((Object)sources).getBytes());
                outputStream.flush();
                outputStream.close();
            }
            InputStream inputStream = connection.getInputStream();
            toReturn = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            inputStream.close();
        }
        catch (ProtocolException e) {
            LOGGER.error((Object)e);
        }
        catch (MalformedURLException e) {
            LOGGER.error((Object)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)e);
        }
        return toReturn;
    }
}

