package ru.leon0399.daomanager.hibernate.dao;

import ru.leon0399.daomanager.command.ReturnableDaoCommand;
import ru.leon0399.daomanager.dao.AbstractDao;
import ru.leon0399.daomanager.manager.DaoManager;

import javax.persistence.NamedQuery;
import javax.persistence.TypedQuery;
import java.io.Serializable;

/**
 * @author leon0399
 * @version 0.1.0-SNAPSHOT
 * @since 0.1.0-SNAPSHOT
 */
public abstract class AbstractHibernateDao<T extends Serializable> extends AbstractDao<T> implements HibernateDao<T> {
    public AbstractHibernateDao(DaoManager daoManager, Class<T> entityClass) {
        super(daoManager, entityClass);
    }

    /**
     * Performs already-created query
     *
     * @param queryName Named query name. See {@link NamedQuery#name()}
     * @return {@link TypedQuery}
     * @see NamedQuery
     * @see <a href="http://www.objectdb.com/java/jpa/query/named">ObjectDB</a>
     * @since 0.1.0-SNAPSHOT
     */
    public TypedQuery<T> namedQuery(final String queryName) {
        return getDaoManager().execute(new ReturnableDaoCommand<TypedQuery<T>>() {
            public TypedQuery<T> execute(DaoManager daoManager) {
                return daoManager.getEntityManager().createNamedQuery(queryName, getEntityClass());
            }
        });
    }

    /**
     * Performs SQL query
     *
     * @param queryString SQL query string
     * @return {@link TypedQuery}
     * @since 0.1.0-SNAPSHOT
     */
    public TypedQuery<T> query(final String queryString) {
        return getDaoManager().execute(new ReturnableDaoCommand<TypedQuery<T>>() {
            public TypedQuery<T> execute(DaoManager daoManager) {
                return daoManager.getEntityManager().createQuery(queryString, getEntityClass());
            }
        });
    }
}
