package ru.leon0399.daomanager.hibernate.dao;

import ru.leon0399.daomanager.dao.Dao;

import javax.persistence.NamedQuery;
import javax.persistence.TypedQuery;
import java.io.Serializable;

/**
 * @author leon0399
 * @version 0.1.0-SNAPSHOT
 * @since 0.1.0-SNAPSHOT
 */
public interface HibernateDao<T extends Serializable> extends Dao<T> {
    /**
     * Performs already-created query
     *
     * @param queryName Named query name. See {@link NamedQuery#name()}
     * @return {@link TypedQuery}
     * @see javax.persistence.NamedQuery
     * @see <a href="http://www.objectdb.com/java/jpa/query/named">ObjectDB</a>
     * @since 0.1.0-SNAPSHOT
     */
    TypedQuery<T> namedQuery(final String queryName);

    /**
     * Performs SQL query
     *
     * @param queryString SQL query string
     * @return {@link TypedQuery}
     * @since 0.1.0-SNAPSHOT
     */
    TypedQuery<T> query(final String queryString);
}
