/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.moysklad.remap_1_2.entities.Context;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.responses.ListEntity;

public class ListEntityDeserializer
implements JsonDeserializer<ListEntity> {
    private static final Logger logger = LoggerFactory.getLogger(ListEntityDeserializer.class);

    public ListEntity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ListEntity le;
        block7: {
            le = new ListEntity();
            le.setMeta((Meta)context.deserialize((JsonElement)((JsonObject)json).getAsJsonObject("meta"), Meta.class));
            le.setContext((Context)context.deserialize((JsonElement)((JsonObject)json).getAsJsonObject("context"), Context.class));
            JsonArray rows = ((JsonObject)json).getAsJsonArray("rows");
            if (rows == null) break block7;
            le.setRows(new ArrayList(rows.size()));
            if (rows.size() > 0) {
                if (typeOfT instanceof ParameterizedType) {
                    Type pcl = ((ParameterizedType)typeOfT).getActualTypeArguments()[0];
                    for (JsonElement row : rows) {
                        le.getRows().add(context.deserialize(row, pcl));
                    }
                } else {
                    for (JsonElement row : rows) {
                        Class<MetaEntity> metaClass = MetaEntity.class;
                        try {
                            Meta.Type metaType = Meta.Type.find(((JsonObject)row).get("meta").getAsJsonObject().get("type").getAsString());
                            metaClass = metaType.getModelClass();
                        }
                        catch (Exception e) {
                            logger.warn("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u043e \u0432\u0440\u0435\u043c\u044f \u0434\u0435\u0441\u0435\u0440\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0430\u0441\u0441\u0438\u0432\u0430 rows", (Throwable)e);
                        }
                        le.getRows().add(context.deserialize(row, metaClass));
                    }
                }
            }
        }
        return le;
    }
}

