/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.entities;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.entities.MetaEntity;

public class Image
extends MetaEntity {
    private String title;
    private String filename;
    private String content;
    private Long size;
    private LocalDateTime updated;
    private Meta miniature;
    private Meta tiny;

    public Image(String id) {
        super(id);
    }

    public void setContent(File file) throws IOException {
        byte[] encoded = Base64.encodeBase64((byte[])FileUtils.readFileToByteArray((File)file));
        this.filename = file.getName();
        this.content = new String(encoded, StandardCharsets.UTF_8);
    }

    public String getTitle() {
        return this.title;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContent() {
        return this.content;
    }

    public Long getSize() {
        return this.size;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public Meta getMiniature() {
        return this.miniature;
    }

    public Meta getTiny() {
        return this.tiny;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public void setUpdated(LocalDateTime updated) {
        this.updated = updated;
    }

    public void setMiniature(Meta miniature) {
        this.miniature = miniature;
    }

    public void setTiny(Meta tiny) {
        this.tiny = tiny;
    }

    public Image() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        Long this$size = this.getSize();
        Long other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        LocalDateTime this$updated = this.getUpdated();
        LocalDateTime other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        Meta this$miniature = this.getMiniature();
        Meta other$miniature = other.getMiniature();
        if (this$miniature == null ? other$miniature != null : !((Object)this$miniature).equals(other$miniature)) {
            return false;
        }
        Meta this$tiny = this.getTiny();
        Meta other$tiny = other.getTiny();
        return !(this$tiny == null ? other$tiny != null : !((Object)this$tiny).equals(other$tiny));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Image;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        Long $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        LocalDateTime $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        Meta $miniature = this.getMiniature();
        result = result * 59 + ($miniature == null ? 43 : ((Object)$miniature).hashCode());
        Meta $tiny = this.getTiny();
        result = result * 59 + ($tiny == null ? 43 : ((Object)$tiny).hashCode());
        return result;
    }
}

