/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.entities;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import ru.moysklad.remap_1_2.entities.documents.DocumentEntity;

public class DocumentTemplate {
    private String documentType;
    private DocumentEntity document;
    private List<DocumentEntity> documents;

    public String getDocumentType() {
        return this.documentType;
    }

    public DocumentEntity getDocument() {
        return this.document;
    }

    public List<DocumentEntity> getDocuments() {
        return this.documents;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public void setDocument(DocumentEntity document) {
        this.document = document;
    }

    public void setDocuments(List<DocumentEntity> documents) {
        this.documents = documents;
    }

    public static class Serializer
    implements JsonSerializer<DocumentTemplate> {
        public JsonElement serialize(DocumentTemplate src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject serializedDocumentTemplate = new JsonObject();
            if (src.getDocument() != null) {
                JsonObject element = new JsonObject();
                element.add("meta", context.serialize((Object)src.getDocument().getMeta()));
                serializedDocumentTemplate.add(src.getDocumentType(), (JsonElement)element);
            } else if (src.getDocuments() != null) {
                JsonArray metaArray = new JsonArray();
                for (DocumentEntity document : src.getDocuments()) {
                    JsonObject element = new JsonObject();
                    element.add("meta", context.serialize((Object)document.getMeta()));
                    metaArray.add((JsonElement)element);
                }
                serializedDocumentTemplate.add(src.getDocumentType(), (JsonElement)metaArray);
            }
            return serializedDocumentTemplate;
        }
    }
}

