/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.entities;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.util.Arrays;
import ru.moysklad.remap_1_2.entities.AgentAccount;
import ru.moysklad.remap_1_2.entities.Application;
import ru.moysklad.remap_1_2.entities.Assortment;
import ru.moysklad.remap_1_2.entities.AssortmentSettings;
import ru.moysklad.remap_1_2.entities.AttachedFile;
import ru.moysklad.remap_1_2.entities.Attribute;
import ru.moysklad.remap_1_2.entities.BonusTransaction;
import ru.moysklad.remap_1_2.entities.Cashier;
import ru.moysklad.remap_1_2.entities.CompanySettings;
import ru.moysklad.remap_1_2.entities.Consignment;
import ru.moysklad.remap_1_2.entities.ContactPerson;
import ru.moysklad.remap_1_2.entities.Contract;
import ru.moysklad.remap_1_2.entities.CounterpartySettings;
import ru.moysklad.remap_1_2.entities.Country;
import ru.moysklad.remap_1_2.entities.Currency;
import ru.moysklad.remap_1_2.entities.CustomEntityElement;
import ru.moysklad.remap_1_2.entities.ExpenseItem;
import ru.moysklad.remap_1_2.entities.Group;
import ru.moysklad.remap_1_2.entities.Image;
import ru.moysklad.remap_1_2.entities.MediaType;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.Note;
import ru.moysklad.remap_1_2.entities.PriceType;
import ru.moysklad.remap_1_2.entities.ProductFolder;
import ru.moysklad.remap_1_2.entities.Project;
import ru.moysklad.remap_1_2.entities.Publication;
import ru.moysklad.remap_1_2.entities.ReceiptTemplate;
import ru.moysklad.remap_1_2.entities.Region;
import ru.moysklad.remap_1_2.entities.RetailStore;
import ru.moysklad.remap_1_2.entities.State;
import ru.moysklad.remap_1_2.entities.Store;
import ru.moysklad.remap_1_2.entities.Task;
import ru.moysklad.remap_1_2.entities.Template;
import ru.moysklad.remap_1_2.entities.Uom;
import ru.moysklad.remap_1_2.entities.WebHook;
import ru.moysklad.remap_1_2.entities.agents.Counterparty;
import ru.moysklad.remap_1_2.entities.agents.Employee;
import ru.moysklad.remap_1_2.entities.agents.Organization;
import ru.moysklad.remap_1_2.entities.discounts.AccumulationDiscount;
import ru.moysklad.remap_1_2.entities.discounts.BonusProgram;
import ru.moysklad.remap_1_2.entities.discounts.Discount;
import ru.moysklad.remap_1_2.entities.discounts.PersonalDiscount;
import ru.moysklad.remap_1_2.entities.discounts.SpecialPriceDiscount;
import ru.moysklad.remap_1_2.entities.documents.CashIn;
import ru.moysklad.remap_1_2.entities.documents.CashOut;
import ru.moysklad.remap_1_2.entities.documents.CommissionReportIn;
import ru.moysklad.remap_1_2.entities.documents.CommissionReportOut;
import ru.moysklad.remap_1_2.entities.documents.CustomerOrder;
import ru.moysklad.remap_1_2.entities.documents.Demand;
import ru.moysklad.remap_1_2.entities.documents.DocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.Enter;
import ru.moysklad.remap_1_2.entities.documents.FactureIn;
import ru.moysklad.remap_1_2.entities.documents.FactureOut;
import ru.moysklad.remap_1_2.entities.documents.InternalOrder;
import ru.moysklad.remap_1_2.entities.documents.Inventory;
import ru.moysklad.remap_1_2.entities.documents.InvoiceIn;
import ru.moysklad.remap_1_2.entities.documents.InvoiceOut;
import ru.moysklad.remap_1_2.entities.documents.Loss;
import ru.moysklad.remap_1_2.entities.documents.Move;
import ru.moysklad.remap_1_2.entities.documents.PaymentIn;
import ru.moysklad.remap_1_2.entities.documents.PaymentOut;
import ru.moysklad.remap_1_2.entities.documents.Prepayment;
import ru.moysklad.remap_1_2.entities.documents.PrepaymentReturn;
import ru.moysklad.remap_1_2.entities.documents.Pricelist;
import ru.moysklad.remap_1_2.entities.documents.Processing;
import ru.moysklad.remap_1_2.entities.documents.ProcessingOrder;
import ru.moysklad.remap_1_2.entities.documents.ProcessingPlan;
import ru.moysklad.remap_1_2.entities.documents.PurchaseOrder;
import ru.moysklad.remap_1_2.entities.documents.PurchaseReturn;
import ru.moysklad.remap_1_2.entities.documents.RetailDemand;
import ru.moysklad.remap_1_2.entities.documents.RetailDrawerCashIn;
import ru.moysklad.remap_1_2.entities.documents.RetailDrawerCashOut;
import ru.moysklad.remap_1_2.entities.documents.RetailSalesReturn;
import ru.moysklad.remap_1_2.entities.documents.RetailShift;
import ru.moysklad.remap_1_2.entities.documents.SalesReturn;
import ru.moysklad.remap_1_2.entities.documents.Supply;
import ru.moysklad.remap_1_2.entities.documents.positions.CommissionReportDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.CustomerOrderDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.DemandDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.EnterDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.InternalOrderDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.InventoryDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.InvoiceDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.LossDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.MoveDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.PrepaymentDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.ProcessingOrderPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.PurchaseOrderDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.PurchaseReturnDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.SalesReturnDocumentPosition;
import ru.moysklad.remap_1_2.entities.documents.positions.SupplyDocumentPosition;
import ru.moysklad.remap_1_2.entities.notifications.Notification;
import ru.moysklad.remap_1_2.entities.notifications.NotificationCustomerOrder;
import ru.moysklad.remap_1_2.entities.notifications.NotificationExchange;
import ru.moysklad.remap_1_2.entities.notifications.NotificationGoodCountTooLow;
import ru.moysklad.remap_1_2.entities.notifications.NotificationInvoiceOutOverdue;
import ru.moysklad.remap_1_2.entities.notifications.NotificationRetailShift;
import ru.moysklad.remap_1_2.entities.notifications.NotificationRetailShiftClosed;
import ru.moysklad.remap_1_2.entities.notifications.NotificationSubscribeExpired;
import ru.moysklad.remap_1_2.entities.notifications.NotificationSubscribeTermsExpired;
import ru.moysklad.remap_1_2.entities.notifications.NotificationTask;
import ru.moysklad.remap_1_2.entities.notifications.NotificationTaskChanged;
import ru.moysklad.remap_1_2.entities.notifications.NotificationTaskComment;
import ru.moysklad.remap_1_2.entities.permissions.EmployeeRole;
import ru.moysklad.remap_1_2.entities.products.Bundle;
import ru.moysklad.remap_1_2.entities.products.Product;
import ru.moysklad.remap_1_2.entities.products.Service;
import ru.moysklad.remap_1_2.entities.products.Variant;
import ru.moysklad.remap_1_2.responses.metadata.CompanySettingsMetadata;
import ru.moysklad.remap_1_2.utils.MetaHrefUtils;

public final class Meta {
    private String href;
    private String metadataHref;
    private Type type;
    private MediaType mediaType;
    private String uuidHref;
    private Integer size;
    private Integer limit;
    private Integer offset;

    public Meta(MetaEntity entity, String host) {
        if (entity == null || entity.getId() == null || host == null) {
            return;
        }
        this.type = Type.find(entity);
        this.href = MetaHrefUtils.makeHref(this.type, entity, host);
        if (this.type != Type.CUSTOM_TEMPLATE && this.type != Type.EMBEDDED_TEMPLATE) {
            this.metadataHref = MetaHrefUtils.makeMetadataHref(this.type, entity, host);
        }
    }

    public String getHref() {
        return this.href;
    }

    public String getMetadataHref() {
        return this.metadataHref;
    }

    public Type getType() {
        return this.type;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getUuidHref() {
        return this.uuidHref;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public void setMetadataHref(String metadataHref) {
        this.metadataHref = metadataHref;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void setUuidHref(String uuidHref) {
        this.uuidHref = uuidHref;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Meta() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Meta)) {
            return false;
        }
        Meta other = (Meta)o;
        String this$href = this.getHref();
        String other$href = other.getHref();
        if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
            return false;
        }
        String this$metadataHref = this.getMetadataHref();
        String other$metadataHref = other.getMetadataHref();
        if (this$metadataHref == null ? other$metadataHref != null : !this$metadataHref.equals(other$metadataHref)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        MediaType this$mediaType = this.getMediaType();
        MediaType other$mediaType = other.getMediaType();
        if (this$mediaType == null ? other$mediaType != null : !((Object)((Object)this$mediaType)).equals((Object)other$mediaType)) {
            return false;
        }
        String this$uuidHref = this.getUuidHref();
        String other$uuidHref = other.getUuidHref();
        if (this$uuidHref == null ? other$uuidHref != null : !this$uuidHref.equals(other$uuidHref)) {
            return false;
        }
        Integer this$size = this.getSize();
        Integer other$size = other.getSize();
        if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        return !(this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        String $metadataHref = this.getMetadataHref();
        result = result * 59 + ($metadataHref == null ? 43 : $metadataHref.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        MediaType $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : ((Object)((Object)$mediaType)).hashCode());
        String $uuidHref = this.getUuidHref();
        result = result * 59 + ($uuidHref == null ? 43 : $uuidHref.hashCode());
        Integer $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        return result;
    }

    public static enum Type {
        ACCOUNT("account", AgentAccount.class),
        ACCUMULATION_DISCOUNT("accumulationdiscount", AccumulationDiscount.class),
        APPLICATION("application", Application.class),
        ASSORTMENT("assortment", Assortment.class),
        ASSORTMENT_SETTINGS("assortmentsettings", AssortmentSettings.class),
        ATTRIBUTE_METADATA("attributemetadata", Attribute.class),
        BONUS_PROGRAM("bonusprogram", BonusProgram.class),
        BONUS_TRANSACTION("bonustransaction", BonusTransaction.class),
        BUNDLE("bundle", Bundle.class),
        BUNDLE_COMPONENT("bundlecomponent", Bundle.ComponentEntity.class),
        CASHIER("cashier", Cashier.class),
        CASH_IN("cashin", CashIn.class),
        CASH_OUT("cashout", CashOut.class),
        COMMISSION_REPORT_IN("commissionreportin", CommissionReportIn.class),
        COMMISSION_REPORT_IN_POSITION("commissionreportinposition", CommissionReportDocumentPosition.class),
        COMMISSION_REPORT_OUT("commissionreportout", CommissionReportOut.class),
        COMMISSION_REPORT_OUT_POSITION("commissionreportoutposition", CommissionReportDocumentPosition.class),
        COMPANY_SETTINGS("companysettings", CompanySettings.class),
        CONSIGNMENT("consignment", Consignment.class),
        CONTACT_PERSON("contactperson", ContactPerson.class),
        CONTRACT("contract", Contract.class),
        CONTRACT_PUBLICATION("contractpublication", Publication.class),
        COUNTERPARTY("counterparty", Counterparty.class),
        COUNTRY("country", Country.class),
        CURRENCY("currency", Currency.class),
        CUSTOMER_ORDER("customerorder", CustomerOrder.class),
        CUSTOMER_ORDER_POSITION("customerorderposition", CustomerOrderDocumentPosition.class),
        CUSTOM_ENTITY("customentity", CustomEntityElement.class),
        CUSTOM_ENTITY_METADATA("customentitymetadata", CompanySettingsMetadata.CustomEntityMetadata.class),
        CUSTOM_TEMPLATE("customtemplate", Template.class),
        DEMAND("demand", Demand.class),
        DEMAND_POSITION("demandposition", DemandDocumentPosition.class),
        DISCOUNT("discount", Discount.class),
        EMBEDDED_TEMPLATE("embeddedtemplate", Template.class),
        EMPLOYEE("employee", Employee.class),
        ENTER("enter", Enter.class),
        ENTER_POSITION("enterposition", EnterDocumentPosition.class),
        EXPENSE_ITEM("expenseitem", ExpenseItem.class),
        FACTURE_IN("facturein", FactureIn.class),
        FACTURE_OUT("factureout", FactureOut.class),
        GROUP("group", Group.class),
        IMAGE("image", Image.class),
        FILE("files", AttachedFile.class),
        INTERNAL_ORDER("internalorder", InternalOrder.class),
        INTERNAL_ORDER_POSITION("internalorderposition", InternalOrderDocumentPosition.class),
        INVENTORY("inventory", Inventory.class),
        INVENTORY_POSITION("inventoryposition", InventoryDocumentPosition.class),
        INVOICE_IN("invoicein", InvoiceIn.class),
        INVOICE_OUT("invoiceout", InvoiceOut.class),
        INVOICE_POSITION("invoiceposition", InvoiceDocumentPosition.class),
        LOSS("loss", Loss.class),
        LOSS_POSITION("lossposition", LossDocumentPosition.class),
        MOVE("move", Move.class),
        MOVE_POSITION("moveposition", MoveDocumentPosition.class),
        NOTE("note", Note.class),
        NOTIFICATION("notification", Notification.class),
        NOTIFICATION_EXPORT_COMPLETED("NotificationExportCompleted", NotificationExchange.class),
        NOTIFICATION_GOOD_COUNT_TOO_LOW("NotificationGoodCountTooLow", NotificationGoodCountTooLow.class),
        NOTIFICATION_IMPORT_COMPLETED("NotificationImportCompleted", NotificationExchange.class),
        NOTIFICATION_INVOICE_OUT_OVERDUE("NotificationInvoiceOutOverdue", NotificationInvoiceOutOverdue.class),
        NOTIFICATION_ORDER_NEW("NotificationOrderNew", NotificationCustomerOrder.class),
        NOTIFICATION_ORDER_OVERDUE("NotificationOrderOverdue", NotificationCustomerOrder.class),
        NOTIFICATION_RETAIL_SHIFT_CLOSED("NotificationRetailShiftClosed", NotificationRetailShiftClosed.class),
        NOTIFICATION_RETAIL_SHIFT_OPENED("NotificationRetailShiftOpened", NotificationRetailShift.class),
        NOTIFICATION_SUBSCRIBE_EXPIRED("NotificationSubscribeExpired", NotificationSubscribeExpired.class),
        NOTIFICATION_SUBSCRIBE_TERMS_EXPIRED("NotificationSubscribeTermsExpired", NotificationSubscribeTermsExpired.class),
        NOTIFICATION_TASK_ASSIGNED("NotificationTaskAssigned", NotificationTask.class),
        NOTIFICATION_TASK_CHANGED("NotificationTaskChanged", NotificationTaskChanged.class),
        NOTIFICATION_TASK_COMMENT_CHANGED("NotificationTaskCommentChanged", NotificationTaskChanged.class),
        NOTIFICATION_TASK_COMMENT_DELETED("NotificationTaskCommentDeleted", NotificationTaskComment.class),
        NOTIFICATION_TASK_COMPLETED("NotificationTaskCompleted", NotificationTask.class),
        NOTIFICATION_TASK_DELETED("NotificationTaskDeleted", NotificationTask.class),
        NOTIFICATION_TASK_NEW_COMMENT("NotificationTaskNewComment", NotificationTaskComment.class),
        NOTIFICATION_TASK_OVERDUE("NotificationTaskOverdue", NotificationTask.class),
        NOTIFICATION_TASK_REOPENED("NotificationTaskReopened", NotificationTask.class),
        NOTIFICATION_TASK_UNASSIGNED("NotificationTaskUnassigned", NotificationTask.class),
        OPERATION_PUBLICATION("operationpublication", Publication.class),
        ORGANIZATION("organization", Organization.class),
        PAYMENT_IN("paymentin", PaymentIn.class),
        PAYMENT_OUT("paymentout", PaymentOut.class),
        PERSONAL_DISCOUNT("personaldiscount", PersonalDiscount.class),
        PREPAYMENT("prepayment", Prepayment.class),
        PREPAYMENT_POSITION("prepaymentposition", PrepaymentDocumentPosition.class),
        PREPAYMENT_RETURN("prepaymentreturn", PrepaymentReturn.class),
        PREPAYMENT_RETURN_POSITION("prepaymentreturnposition", PrepaymentDocumentPosition.class),
        PRICE_LIST("pricelist", Pricelist.class),
        PRICE_LIST_ROW("pricelistrow", Pricelist.PricelistRow.class),
        PRICE_TYPE("pricetype", PriceType.class),
        PROCESSING("processing", Processing.class),
        PROCESSING_ORDER("processingorder", ProcessingOrder.class),
        PROCESSING_ORDER_POSITION("processingorderposition", ProcessingOrderPosition.class),
        PROCESSING_PLAN("processingplan", ProcessingPlan.class),
        PROCESSING_PLAN_MATERIAL("processingplanmaterial", ProcessingPlan.PlanItem.class),
        PROCESSING_PLAN_RESULT("processingplanresult", ProcessingPlan.PlanItem.class),
        PROCESSING_POSITION_MATERIAL("processingpositionmaterial", DocumentPosition.class),
        PROCESSING_POSITION_RESULT("processingpositionresult", DocumentPosition.class),
        PRODUCT("product", Product.class),
        PRODUCT_FOLDER("productfolder", ProductFolder.class),
        PROJECT("project", Project.class),
        PURCHASE_ORDER("purchaseorder", PurchaseOrder.class),
        PURCHASE_ORDER_POSITION("purchaseorderposition", PurchaseOrderDocumentPosition.class),
        PURCHASE_RETURN("purchasereturn", PurchaseReturn.class),
        PURCHASE_RETURN_POSITION("purchasereturnposition", PurchaseReturnDocumentPosition.class),
        RECEIPT_TEMPLATE("receipttemplate", ReceiptTemplate.class),
        REGION("region", Region.class),
        RETAIL_DEMAND("retaildemand", RetailDemand.class),
        RETAIL_DRAWER_CASH_IN("retaildrawercashin", RetailDrawerCashIn.class),
        RETAIL_DRAWER_CASH_OUT("retaildrawercashout", RetailDrawerCashOut.class),
        RETAIL_SALES_RETURN("retailsalesreturn", RetailSalesReturn.class),
        RETAIL_SHIFT("retailshift", RetailShift.class),
        RETAIL_STORE("retailstore", RetailStore.class),
        SALES_RETURN("salesreturn", SalesReturn.class),
        SALES_RETURN_POSITION("salesreturnposition", SalesReturnDocumentPosition.class),
        SERVICE("service", Service.class),
        SPECIAL_PRICE_DISCOUNT("specialpricediscount", SpecialPriceDiscount.class),
        STATE("state", State.class),
        STORE("store", Store.class),
        SUPPLY("supply", Supply.class),
        SUPPLY_POSITION("supplyposition", SupplyDocumentPosition.class),
        TASK("task", Task.class),
        TASK_NOTE("tasknote", Task.TaskNote.class),
        UOM("uom", Uom.class),
        VARIANT("variant", Variant.class),
        WEBHOOK("webhook", WebHook.class),
        COUNTERPARTY_SETTINGS("counterpartysettings", CounterpartySettings.class),
        SYSTEM_ROLE("systemrole", EmployeeRole.class),
        INDIVIDUAL_ROLE("individualrole", EmployeeRole.class),
        CUSTOM_ROLE("customrole", EmployeeRole.class);

        private final Class<? extends MetaEntity> modelClass;
        private final String apiName;

        private Type(String apiName, Class<? extends MetaEntity> clazz) {
            this.modelClass = clazz;
            this.apiName = apiName;
        }

        public static Type find(MetaEntity entity) {
            if (Template.class.isAssignableFrom(entity.getClass())) {
                if (((Template)entity).getIsEmbedded() == null) {
                    return CUSTOM_TEMPLATE;
                }
                return ((Template)entity).getIsEmbedded() != false ? EMBEDDED_TEMPLATE : CUSTOM_TEMPLATE;
            }
            if (Publication.class.isAssignableFrom(entity.getClass())) {
                if (((Publication)entity).getType() == null) {
                    return OPERATION_PUBLICATION;
                }
                return ((Publication)entity).getType() == Publication.PublicationType.OPERATION ? OPERATION_PUBLICATION : CONTRACT_PUBLICATION;
            }
            return Type.find(entity.getClass());
        }

        private static Type find(Class<? extends MetaEntity> clazz) {
            return Arrays.stream(Type.values()).filter(t -> t.modelClass.getSimpleName().equals(clazz.getSimpleName())).findFirst().orElseThrow(() -> new IllegalArgumentException("No type found for class: " + clazz.getSimpleName()));
        }

        public static Type find(String apiName) {
            return Arrays.stream(Type.values()).filter(t -> t.apiName.equals(apiName)).findFirst().orElseThrow(() -> new IllegalArgumentException("No type found for string: " + apiName));
        }

        public Class<? extends MetaEntity> getModelClass() {
            return this.modelClass;
        }

        public String getApiName() {
            return this.apiName;
        }

        public static class Serializer
        implements JsonSerializer<Type>,
        JsonDeserializer<Type> {
            public Type deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return Type.find(json.getAsString());
            }

            public JsonElement serialize(Type src, java.lang.reflect.Type typeOfSrc, JsonSerializationContext context) {
                return context.serialize((Object)src.getApiName());
            }
        }
    }
}

