/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.clients;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import ru.moysklad.remap_1_2.ApiClient;
import ru.moysklad.remap_1_2.clients.EntityClientBase;
import ru.moysklad.remap_1_2.clients.endpoints.ApiEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.DeleteByIdEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.GetByIdEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.GetListEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.MassCreateUpdateDeleteEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.MetadataAttributeEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.MetadataEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.PostEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.PutByIdEndpoint;
import ru.moysklad.remap_1_2.entities.AgentAccount;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.agents.Organization;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.responses.metadata.MetadataAttributeSharedResponse;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.HttpRequestExecutor;
import ru.moysklad.remap_1_2.utils.params.ApiParam;

public final class OrganizationClient
extends EntityClientBase
implements GetListEndpoint<Organization>,
PostEndpoint<Organization>,
DeleteByIdEndpoint,
MetadataEndpoint<MetadataAttributeSharedResponse>,
MetadataAttributeEndpoint,
GetByIdEndpoint<Organization>,
PutByIdEndpoint<Organization>,
MassCreateUpdateDeleteEndpoint<Organization> {
    public OrganizationClient(ApiClient api) {
        super(api, "/entity/organization/");
    }

    @Override
    public Class<? extends MetaEntity> entityClass() {
        return Organization.class;
    }

    @Override
    public Class<? extends MetaEntity> metaEntityClass() {
        return MetadataAttributeSharedResponse.class;
    }

    @ApiEndpoint
    public ListEntity<AgentAccount> getAccounts(String organizationId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + organizationId + "/accounts").apiParams(params).list(AgentAccount.class);
    }

    @ApiEndpoint
    public ListEntity<AgentAccount> getAccounts(Organization organization, ApiParam ... params) throws IOException, ApiClientException {
        return this.getAccounts(organization.getId(), params);
    }

    @ApiEndpoint
    public List<AgentAccount> createAccounts(String organizationId, Collection<AgentAccount> entities) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + organizationId + "/accounts").body(entities).postList(AgentAccount.class);
    }

    @ApiEndpoint
    public List<AgentAccount> createAccounts(Organization organization, Collection<AgentAccount> entities) throws IOException, ApiClientException {
        return this.createAccounts(organization.getId(), entities);
    }
}

