/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.clients;

import java.io.IOException;
import ru.moysklad.remap_1_2.ApiClient;
import ru.moysklad.remap_1_2.clients.EntityClientBase;
import ru.moysklad.remap_1_2.clients.endpoints.ApiEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.DeleteByIdEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.GetByIdEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.GetListEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.MassCreateUpdateDeleteEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.PostEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.PutByIdEndpoint;
import ru.moysklad.remap_1_2.entities.Cashier;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.RetailStore;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.HttpRequestExecutor;
import ru.moysklad.remap_1_2.utils.params.ApiParam;

public final class RetailStoreClient
extends EntityClientBase
implements GetListEndpoint<RetailStore>,
PostEndpoint<RetailStore>,
DeleteByIdEndpoint,
GetByIdEndpoint<RetailStore>,
PutByIdEndpoint<RetailStore>,
MassCreateUpdateDeleteEndpoint<RetailStore> {
    public RetailStoreClient(ApiClient api) {
        super(api, "/entity/retailstore/");
    }

    @ApiEndpoint
    public ListEntity<Cashier> getCashiers(String retailStoreId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + retailStoreId + "/cashiers").apiParams(params).list(Cashier.class);
    }

    @ApiEndpoint
    public ListEntity<Cashier> getCashiers(MetaEntity retailStore, ApiParam ... params) throws IOException, ApiClientException {
        return this.getCashiers(retailStore.getId(), params);
    }

    @ApiEndpoint
    public Cashier getCashier(String retailStoreId, String cashierId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + retailStoreId + "/cashiers/" + cashierId).apiParams(params).get(Cashier.class);
    }

    @ApiEndpoint
    public Cashier getCashier(String retailStoreId, Cashier cashier, ApiParam ... params) throws IOException, ApiClientException {
        return this.getCashier(retailStoreId, cashier.getId(), new ApiParam[0]);
    }

    @ApiEndpoint
    public Cashier getCashier(RetailStore retailStore, String cashierId, ApiParam ... params) throws IOException, ApiClientException {
        return this.getCashier(retailStore.getId(), cashierId, new ApiParam[0]);
    }

    @ApiEndpoint
    public Cashier getCashier(RetailStore retailStore, Cashier cashier, ApiParam ... params) throws IOException, ApiClientException {
        return this.getCashier(retailStore.getId(), cashier.getId(), new ApiParam[0]);
    }

    @Override
    public Class<? extends MetaEntity> entityClass() {
        return RetailStore.class;
    }
}

