/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.clients.endpoints;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import ru.moysklad.remap_1_2.clients.endpoints.ApiEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.Endpoint;
import ru.moysklad.remap_1_2.entities.Image;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.HttpRequestExecutor;
import ru.moysklad.remap_1_2.utils.params.ApiParam;

public interface HasImagesEndpoint<T extends MetaEntity>
extends Endpoint {
    @ApiEndpoint
    default public ListEntity<Image> getImages(String entityId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + entityId + "/images").apiParams(params).list(Image.class);
    }

    @ApiEndpoint
    default public ListEntity<Image> getImages(T entity, ApiParam ... params) throws IOException, ApiClientException {
        return this.getImages((T)((MetaEntity)entity).getId(), params);
    }

    @ApiEndpoint
    default public List<Image> addImage(String entityId, Image image) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + entityId + "/images").body(image).postList(Image.class);
    }

    @ApiEndpoint
    default public List<Image> addImage(T entity, Image image) throws IOException, ApiClientException {
        return this.addImage((T)((MetaEntity)entity).getId(), image);
    }

    @ApiEndpoint
    default public List<Image> updateImages(String entityId, List<Image> images) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + entityId + "/images").body(images).postList(Image.class);
    }

    @ApiEndpoint
    default public List<Image> updateImages(T entity, List<Image> images) throws IOException, ApiClientException {
        return this.updateImages((T)((MetaEntity)entity).getId(), images);
    }

    @ApiEndpoint
    default public void deleteImage(String entityId, String imageId) throws IOException, ApiClientException {
        HttpRequestExecutor.path(this.api(), this.path() + entityId + "/images/" + imageId).delete();
    }

    @ApiEndpoint
    default public void deleteImage(T entity, String imageId) throws IOException, ApiClientException {
        this.deleteImage(((MetaEntity)entity).getId(), imageId);
    }

    @ApiEndpoint
    default public void deleteImage(String entityId, Image image) throws IOException, ApiClientException {
        if (Objects.isNull(image.getId())) {
            String href = image.getMeta().getHref();
            String imageId = href.substring(href.indexOf("images/") + "images/".length());
            this.deleteImage(entityId, imageId);
        } else {
            this.deleteImage(entityId, image.getId());
        }
    }

    @ApiEndpoint
    default public void deleteImage(T entity, Image image) throws IOException, ApiClientException {
        this.deleteImage(((MetaEntity)entity).getId(), image);
    }

    @ApiEndpoint
    default public void deleteImages(String entityId, List<Image> images) throws IOException, ApiClientException {
        HttpRequestExecutor.path(this.api(), this.path() + entityId + "/images/delete").body(images).postList(Image.class);
    }

    @ApiEndpoint
    default public void deleteImages(T entity, List<Image> images) throws IOException, ApiClientException {
        this.deleteImages((T)((MetaEntity)entity).getId(), images);
    }
}

