/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.documents.DocumentEntity;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class DocumentEntitySerializer
implements JsonSerializer<DocumentEntity>,
JsonDeserializer<DocumentEntity> {
    private final Gson gson = JsonUtils.createGsonWithMetaAdapter();

    public JsonElement serialize(DocumentEntity src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    public DocumentEntity deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        MetaEntity me = (MetaEntity)this.gson.fromJson(json, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException("Can't parse field 'operation': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException("Can't parse field 'operation': meta.type is null");
        }
        if (!DocumentEntity.class.isAssignableFrom(me.getMeta().getType().getModelClass())) {
            throw new JsonParseException("Can't parse field 'operation': meta.type is not a valid document type");
        }
        return (DocumentEntity)context.deserialize(json, me.getMeta().getType().getModelClass());
    }
}

