package ru.moysklad.remap_1_2.clients.documents;

import ru.moysklad.remap_1_2.ApiClient;
import ru.moysklad.remap_1_2.clients.endpoints.*;
import ru.moysklad.remap_1_2.clients.EntityClientBase;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.documents.Enter;
import ru.moysklad.remap_1_2.entities.documents.positions.EnterDocumentPosition;
import ru.moysklad.remap_1_2.responses.metadata.MetadataAttributeSharedStatesResponse;

public final class EnterClient
        extends EntityClientBase
        implements
        GetListEndpoint<Enter>,
        PostEndpoint<Enter>,
        DeleteByIdEndpoint,
        DocumentMetadataEndpoint<MetadataAttributeSharedStatesResponse>,
        MetadataAttributeEndpoint,
        GetByIdEndpoint<Enter>,
        PutByIdEndpoint<Enter>,
        MassCreateUpdateDeleteEndpoint<Enter>,
        DocumentPositionsEndpoint<EnterDocumentPosition>,
        ExportEndpoint,
        PublicationEndpoint,
        HasStatesEndpoint,
        HasFilesEndpoint<Enter> {

    public EnterClient(ApiClient api) {
        super(api, "/entity/enter/");
    }

    @Override
    public Class<? extends MetaEntity> entityClass() {
        return Enter.class;
    }

    @Override
    public Class<? extends MetaEntity> metaEntityClass() {
        return MetadataAttributeSharedStatesResponse.class;
    }

    @Override
    public Class<EnterDocumentPosition> documentPositionClass() {
        return EnterDocumentPosition.class;
    }
}
