/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.clients;

import java.io.IOException;
import java.util.List;
import ru.moysklad.remap_1_2.ApiClient;
import ru.moysklad.remap_1_2.clients.EntityClientBase;
import ru.moysklad.remap_1_2.clients.endpoints.ApiEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.DeleteByIdEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.GetByIdEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.GetListEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.HasFilesEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.HasSettingsEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.HasStatesEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.MassCreateUpdateDeleteEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.MetadataAttributeEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.MetadataEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.PostEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.PutByIdEndpoint;
import ru.moysklad.remap_1_2.entities.AgentAccount;
import ru.moysklad.remap_1_2.entities.ContactPerson;
import ru.moysklad.remap_1_2.entities.CounterpartySettings;
import ru.moysklad.remap_1_2.entities.Entity;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.Note;
import ru.moysklad.remap_1_2.entities.agents.Counterparty;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.responses.metadata.CounterpartyMetadataResponse;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.HttpRequestExecutor;
import ru.moysklad.remap_1_2.utils.params.ApiParam;

public final class CounterpartyClient
extends EntityClientBase
implements GetListEndpoint<Counterparty>,
PostEndpoint<Counterparty>,
DeleteByIdEndpoint,
MetadataEndpoint<CounterpartyMetadataResponse>,
MetadataAttributeEndpoint,
GetByIdEndpoint<Counterparty>,
PutByIdEndpoint<Counterparty>,
MassCreateUpdateDeleteEndpoint<Counterparty>,
HasStatesEndpoint,
HasSettingsEndpoint<CounterpartySettings>,
HasFilesEndpoint<Counterparty> {
    public CounterpartyClient(ApiClient api) {
        super(api, "/entity/counterparty/");
    }

    @ApiEndpoint
    public ListEntity<AgentAccount> getAccounts(String id, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + id + "/accounts").apiParams(params).list(AgentAccount.class);
    }

    @ApiEndpoint
    public AgentAccount getAccount(String counterpartyId, String accountId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + counterpartyId + "/accounts/" + accountId).apiParams(params).get(AgentAccount.class);
    }

    @ApiEndpoint
    public AgentAccount getAccount(Counterparty counterparty, String accountId, ApiParam ... params) throws IOException, ApiClientException {
        return this.getAccount(counterparty.getId(), accountId, params);
    }

    @ApiEndpoint
    public AgentAccount getAccount(Counterparty counterparty, AgentAccount account, ApiParam ... params) throws IOException, ApiClientException {
        return this.getAccount(counterparty, account.getId(), params);
    }

    @ApiEndpoint
    public ListEntity<ContactPerson> getContactPersons(String counterpartyId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + counterpartyId + "/contactpersons").apiParams(params).list(ContactPerson.class);
    }

    @ApiEndpoint
    public ListEntity<ContactPerson> getContactPersons(Counterparty counterparty, ApiParam ... params) throws IOException, ApiClientException {
        return this.getContactPersons(counterparty.getId(), params);
    }

    @ApiEndpoint
    public ContactPerson createContactPerson(String counterpartyId, ContactPerson newEntity) throws IOException, ApiClientException {
        List<ContactPerson> responseEntity = HttpRequestExecutor.path(this.api(), this.path() + counterpartyId + "/contactpersons").body(newEntity).postList(ContactPerson.class);
        newEntity.set((Entity)responseEntity.get(0));
        return newEntity;
    }

    @ApiEndpoint
    public ContactPerson getContactPerson(String counterpartyId, String contactPersonId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + counterpartyId + "/contactpersons/" + contactPersonId).apiParams(params).get(ContactPerson.class);
    }

    @ApiEndpoint
    public ContactPerson getContactPerson(Counterparty counterparty, String contactPersonId, ApiParam ... params) throws IOException, ApiClientException {
        return this.getContactPerson(counterparty.getId(), contactPersonId, params);
    }

    @ApiEndpoint
    public ContactPerson getContactPerson(Counterparty counterparty, ContactPerson contactPerson, ApiParam ... params) throws IOException, ApiClientException {
        return this.getContactPerson(counterparty, contactPerson.getId(), params);
    }

    @ApiEndpoint
    public void updateContactPerson(String counterpartyId, String contactPersonId, ContactPerson updatedEntity) throws IOException, ApiClientException {
        ContactPerson responseEntity = HttpRequestExecutor.path(this.api(), this.path() + counterpartyId + "/contactpersons/" + contactPersonId).body(updatedEntity).put(ContactPerson.class);
        updatedEntity.set(responseEntity);
    }

    @ApiEndpoint
    public void updateContactPerson(Counterparty counterparty, String contactPersonId, ContactPerson updatedEntity) throws IOException, ApiClientException {
        this.updateContactPerson(counterparty.getId(), contactPersonId, updatedEntity);
    }

    @ApiEndpoint
    public void updateContactPerson(Counterparty counterparty, ContactPerson contactPerson, ContactPerson updatedEntity) throws IOException, ApiClientException {
        this.updateContactPerson(counterparty, contactPerson.getId(), updatedEntity);
    }

    @ApiEndpoint
    public void updateContactPerson(Counterparty counterparty, ContactPerson contactPerson) throws IOException, ApiClientException {
        this.updateContactPerson(counterparty, contactPerson.getId(), contactPerson);
    }

    @ApiEndpoint
    public ListEntity<Note> getNotes(String counterpartyId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + counterpartyId + "/notes").apiParams(params).list(Note.class);
    }

    @ApiEndpoint
    public ListEntity<Note> getNotes(Counterparty counterparty, ApiParam ... params) throws IOException, ApiClientException {
        return this.getNotes(counterparty.getId(), params);
    }

    @ApiEndpoint
    public Note createNote(String counterpartyId, Note newEntity) throws IOException, ApiClientException {
        List<Note> responseEntity = HttpRequestExecutor.path(this.api(), this.path() + counterpartyId + "/notes").body(newEntity).postList(Note.class);
        newEntity.set((Entity)responseEntity.get(0));
        return newEntity;
    }

    @ApiEndpoint
    public Note getNote(String counterpartyId, String noteId) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + counterpartyId + "/notes/" + noteId).get(Note.class);
    }

    @ApiEndpoint
    public Note getNote(Counterparty counterparty, String noteId) throws IOException, ApiClientException {
        return this.getNote(counterparty.getId(), noteId);
    }

    @ApiEndpoint
    public Note getNote(Counterparty counterparty, Note note) throws IOException, ApiClientException {
        return this.getNote(counterparty, note.getId());
    }

    @ApiEndpoint
    public void updateNote(String counterpartyId, String noteId, Note updatedEntity) throws IOException, ApiClientException {
        Note responseEntity = HttpRequestExecutor.path(this.api(), this.path() + counterpartyId + "/notes/" + noteId).body(updatedEntity).put(Note.class);
        updatedEntity.set(responseEntity);
    }

    @ApiEndpoint
    public void updateNote(Counterparty counterparty, String noteId, Note updatedEntity) throws IOException, ApiClientException {
        this.updateNote(counterparty.getId(), noteId, updatedEntity);
    }

    @ApiEndpoint
    public void updateNote(Counterparty counterparty, Note note, Note updatedEntity) throws IOException, ApiClientException {
        this.updateNote(counterparty, note.getId(), updatedEntity);
    }

    @ApiEndpoint
    public void updateNote(Counterparty counterparty, Note note) throws IOException, ApiClientException {
        this.updateNote(counterparty, note.getId(), note);
    }

    @ApiEndpoint
    public void deleteNote(String counterpartyId, String noteId) throws IOException, ApiClientException {
        HttpRequestExecutor.path(this.api(), this.path() + counterpartyId + "/notes/" + noteId).delete();
    }

    @ApiEndpoint
    public void deleteNote(Counterparty counterparty, String noteId) throws IOException, ApiClientException {
        this.deleteNote(counterparty.getId(), noteId);
    }

    @ApiEndpoint
    public void deleteNote(Counterparty counterparty, Note note) throws IOException, ApiClientException {
        this.deleteNote(counterparty, note.getId());
    }

    @Override
    public Class<? extends MetaEntity> entityClass() {
        return Counterparty.class;
    }

    @Override
    public Class<? extends MetaEntity> metaEntityClass() {
        return CounterpartyMetadataResponse.class;
    }

    @Override
    public Class<CounterpartySettings> settingsEntityClass() {
        return CounterpartySettings.class;
    }
}

