/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.clients.endpoints;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import ru.moysklad.remap_1_2.clients.endpoints.ApiEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.Endpoint;
import ru.moysklad.remap_1_2.entities.DocumentTemplate;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.documents.DocumentEntity;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.HttpRequestExecutor;
import ru.moysklad.remap_1_2.utils.MetaHrefUtils;

public interface DocumentNewEndpoint<T extends MetaEntity>
extends Endpoint {
    @ApiEndpoint
    default public T templateDocument() throws IOException, ApiClientException {
        return (T)HttpRequestExecutor.path(this.api(), this.path() + "new").body(new Object()).put(this.entityClass());
    }

    @ApiEndpoint
    default public T templateDocument(DocumentTemplate documentTemplate) throws IOException, ApiClientException {
        if (documentTemplate.getDocument() != null) {
            MetaHrefUtils.fillMeta(documentTemplate.getDocument(), this.api().getHost() + "/api/remap/1.2");
        } else if (documentTemplate.getDocuments() != null) {
            List<DocumentEntity> documents = documentTemplate.getDocuments();
            documents = documents.stream().map(d -> MetaHrefUtils.fillMeta(d, this.api().getHost() + "/api/remap/1.2")).collect(Collectors.toList());
            documentTemplate.setDocuments(documents);
        }
        return (T)HttpRequestExecutor.path(this.api(), this.path() + "new").body(documentTemplate).put(this.entityClass());
    }

    @ApiEndpoint
    default public T templateDocument(String templateClassString, DocumentEntity document) throws IOException, ApiClientException {
        DocumentTemplate documentTemplate = new DocumentTemplate();
        documentTemplate.setDocumentType(templateClassString);
        documentTemplate.setDocument(document);
        return this.templateDocument(documentTemplate);
    }

    @ApiEndpoint
    default public T templateDocument(String templateClassString, List<DocumentEntity> documents) throws IOException, ApiClientException {
        DocumentTemplate documentTemplate = new DocumentTemplate();
        documentTemplate.setDocumentType(templateClassString);
        documentTemplate.setDocuments(documents);
        return this.templateDocument(documentTemplate);
    }
}

