/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.documents.CashIn;
import ru.moysklad.remap_1_2.entities.documents.CashOut;
import ru.moysklad.remap_1_2.entities.documents.PaymentIn;
import ru.moysklad.remap_1_2.entities.documents.PaymentOut;
import ru.moysklad.remap_1_2.entities.documents.markers.FinanceDocumentMarker;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class FinanceDocumentMarkerSerializer
implements JsonSerializer<FinanceDocumentMarker>,
JsonDeserializer<FinanceDocumentMarker> {
    private final Gson gson = JsonUtils.createGsonWithMetaAdapter();

    public JsonElement serialize(FinanceDocumentMarker src, Type typeOfSrc, JsonSerializationContext context) {
        return context.serialize((Object)src);
    }

    public FinanceDocumentMarker deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        MetaEntity me = (MetaEntity)this.gson.fromJson(json, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException("Can't parse field 'payments': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException("Can't parse field 'payments': meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case CASH_IN: {
                return (FinanceDocumentMarker)context.deserialize(json, CashIn.class);
            }
            case CASH_OUT: {
                return (FinanceDocumentMarker)context.deserialize(json, CashOut.class);
            }
            case PAYMENT_IN: {
                return (FinanceDocumentMarker)context.deserialize(json, PaymentIn.class);
            }
            case PAYMENT_OUT: {
                return (FinanceDocumentMarker)context.deserialize(json, PaymentOut.class);
            }
        }
        throw new JsonParseException("Can't parse field 'payments': meta.type must be one of [cashin, cashout, paymentin, paymentout]");
    }
}

