/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.clients;

import java.io.IOException;
import java.util.List;
import ru.moysklad.remap_1_2.ApiClient;
import ru.moysklad.remap_1_2.clients.EntityClientBase;
import ru.moysklad.remap_1_2.clients.endpoints.ApiEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.DeleteByIdEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.GetByIdEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.GetListEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.HasFilesEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.MassCreateUpdateDeleteEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.PostEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.PutByIdEndpoint;
import ru.moysklad.remap_1_2.entities.Entity;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.Task;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.HttpRequestExecutor;
import ru.moysklad.remap_1_2.utils.params.ApiParam;

public final class TaskClient
extends EntityClientBase
implements GetListEndpoint<Task>,
GetByIdEndpoint<Task>,
MassCreateUpdateDeleteEndpoint<Task>,
PostEndpoint<Task>,
PutByIdEndpoint<Task>,
DeleteByIdEndpoint,
HasFilesEndpoint<Task> {
    TaskClient(ApiClient api) {
        super(api, "/entity/task/");
    }

    @ApiEndpoint
    public ListEntity<Task.TaskNote> getNotes(String taskId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + taskId + "/notes").apiParams(params).list(Task.TaskNote.class);
    }

    @ApiEndpoint
    public ListEntity<Task.TaskNote> getNotes(Task task, ApiParam ... params) throws IOException, ApiClientException {
        return this.getNotes(task.getId(), params);
    }

    @ApiEndpoint
    public Task.TaskNote createNote(String taskId, Task.TaskNote newEntity) throws IOException, ApiClientException {
        List<Task.TaskNote> responseEntity = HttpRequestExecutor.path(this.api(), this.path() + taskId + "/notes").body(newEntity).postList(Task.TaskNote.class);
        newEntity.set((Entity)responseEntity.get(0));
        return newEntity;
    }

    @ApiEndpoint
    public Task.TaskNote createNote(Task task, Task.TaskNote newEntity) throws IOException, ApiClientException {
        return this.createNote(task.getId(), newEntity);
    }

    @ApiEndpoint
    public Task.TaskNote getNote(String taskId, String taskNoteId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + taskId + "/notes/" + taskNoteId).apiParams(params).get(Task.TaskNote.class);
    }

    @ApiEndpoint
    public Task.TaskNote getNote(Task task, String taskNoteId, ApiParam ... params) throws IOException, ApiClientException {
        return this.getNote(task.getId(), taskNoteId, params);
    }

    @ApiEndpoint
    public Task.TaskNote getNote(Task task, Task.TaskNote taskNote, ApiParam ... params) throws IOException, ApiClientException {
        return this.getNote(task, taskNote.getId(), params);
    }

    @ApiEndpoint
    public void updateNote(String taskId, String taskNoteId, Task.TaskNote updatedEntity) throws IOException, ApiClientException {
        Task.TaskNote responseEntity = HttpRequestExecutor.path(this.api(), this.path() + taskId + "/notes/" + taskNoteId).body(updatedEntity).put(Task.TaskNote.class);
        updatedEntity.set(responseEntity);
    }

    @ApiEndpoint
    public void updateNote(Task task, String taskNoteId, Task.TaskNote updatedEntity) throws IOException, ApiClientException {
        this.updateNote(task.getId(), taskNoteId, updatedEntity);
    }

    @ApiEndpoint
    public void updateNote(Task task, Task.TaskNote taskNote, Task.TaskNote updatedEntity) throws IOException, ApiClientException {
        this.updateNote(task, taskNote.getId(), updatedEntity);
    }

    @ApiEndpoint
    public void updateNote(Task task, Task.TaskNote taskNote) throws IOException, ApiClientException {
        this.updateNote(task, taskNote.getId(), taskNote);
    }

    @ApiEndpoint
    public void deleteNote(String taskId, String taskNoteId) throws IOException, ApiClientException {
        HttpRequestExecutor.path(this.api(), this.path() + taskId + "/notes/" + taskNoteId).delete();
    }

    @ApiEndpoint
    public void deleteNote(Task task, String taskNoteId) throws IOException, ApiClientException {
        this.deleteNote(task.getId(), taskNoteId);
    }

    @ApiEndpoint
    public void deleteNote(Task task, Task.TaskNote taskNote) throws IOException, ApiClientException {
        this.deleteNote(task, taskNote.getId());
    }

    @Override
    public Class<? extends MetaEntity> entityClass() {
        return Task.class;
    }
}

