package ru.moysklad.remap_1_2.entities.documents;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import ru.moysklad.remap_1_2.entities.*;
import ru.moysklad.remap_1_2.entities.agents.Agent;
import ru.moysklad.remap_1_2.entities.documents.markers.FinanceDocumentMarker;
import ru.moysklad.remap_1_2.entities.documents.positions.PurchaseReturnDocumentPosition;
import ru.moysklad.remap_1_2.entities.products.markers.HasFiles;
import ru.moysklad.remap_1_2.responses.ListEntity;

import java.time.LocalDateTime;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class PurchaseReturn extends DocumentEntity implements IEntityWithAttributes, HasFiles {
    private Agent agent;
    private LocalDateTime created;
    private String externalCode;
    private Agent organization;
    private Long payedSum;
    private ListEntity<PurchaseReturnDocumentPosition> positions;
    private Rate rate;
    private Store store;
    private Supply supply;
    private Boolean vatEnabled;
    private Boolean vatIncluded;
    private Long vatSum;
    private String syncId;
    private LocalDateTime deleted;
    private String description;
    private Contract contract;
    private Project project;
    private State state;
    private AgentAccount organizationAccount;
    private AgentAccount agentAccount;
    private List<Attribute> attributes;
    private FactureOut factureOut;
    private List<FinanceDocumentMarker> payments;
    private ListEntity<AttachedFile> files;

    public PurchaseReturn(String id) {
        super(id);
    }
}
