/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.entities;

import com.google.gson.JsonElement;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import ru.moysklad.remap_1_2.entities.Address;
import ru.moysklad.remap_1_2.entities.Cashier;
import ru.moysklad.remap_1_2.entities.Fetchable;
import ru.moysklad.remap_1_2.entities.Group;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.PriceType;
import ru.moysklad.remap_1_2.entities.ProductFolder;
import ru.moysklad.remap_1_2.entities.ReceiptTemplate;
import ru.moysklad.remap_1_2.entities.State;
import ru.moysklad.remap_1_2.entities.Store;
import ru.moysklad.remap_1_2.entities.TaxSystem;
import ru.moysklad.remap_1_2.entities.agents.Agent;
import ru.moysklad.remap_1_2.entities.agents.Employee;
import ru.moysklad.remap_1_2.entities.agents.Organization;
import ru.moysklad.remap_1_2.responses.ListEntity;

public class RetailStore
extends MetaEntity
implements Fetchable {
    private Boolean shared;
    private Boolean controlCashierChoice;
    private String externalCode;
    private String frNumber;
    private Boolean controlShippingStock;
    private Boolean ofdEnabled;
    private Boolean archived;
    private Boolean issueOrders;
    private List<LastOperationNamesItem> lastOperationNames;
    private RetailStoreState state;
    private Group group;
    private Employee owner;
    private Boolean allowCustomPrice;
    private PriceType priceType;
    @JsonAdapter(value=CashiersSerializer.class)
    private ListEntity<Cashier> cashiers;
    private Boolean active;
    private Store store;
    private Boolean discountEnable;
    private Environment environment;
    private Boolean sellReserves;
    private Boolean authTokenAttached;
    private Boolean egaisEnabled;
    private Organization organization;
    private Integer discountMaxPercent;
    private LocalDateTime updated;
    private String description;
    private String address;
    private Address addressFull;
    private Boolean onlyInStock;
    private Agent acquire;
    private State orderToState;
    private List<State> customerOrderStates;
    private TaxSystem defaultTaxSystem;
    private TaxSystem orderTaxSystem;
    private Boolean allowCreateProducts;
    private PriorityOfdSend priorityOfdSend;
    private String demandPrefix;
    private Boolean allowSellTobaccoWithoutMRC;
    private TobaccoMrcControlType tobaccoMrcControlType;
    private ListEntity<ProductFolder> productFolders;
    private List<String> createAgentsTags;
    private List<String> filterAgentsTags;
    private Boolean printAlways;
    private ReceiptTemplate receiptTemplate;
    private Boolean createPaymentInOnRetailShiftClosing;
    private Boolean createCashInOnRetailShiftClosing;
    private Boolean returnFromClosedShiftEnabled;
    private Boolean enableReturnsWithNoReason;
    private State createOrderWithState;
    private Boolean reservePrepaidGoods;
    private Double bankPercent;
    private FiscalType fiscalType;
    private Boolean qrPayEnabled;
    private Agent qrAcquire;
    private MinionToMasterType minionToMasterType;
    private ListEntity<RetailStore> masterRetailStores;
    private Double qrBankPercent;
    private MarkingSellingMode markingSellingMode;

    public RetailStore(String id) {
        super(id);
    }

    public void setCashiers(Collection<Employee> employees) {
        this.cashiers = new ListEntity();
        this.cashiers.setRows(employees.stream().map(e -> {
            Cashier cashier = new Cashier();
            cashier.setEmployee((Employee)e);
            return cashier;
        }).collect(Collectors.toList()));
    }

    public void setCashiers(ListEntity<Cashier> cashiers) {
        this.cashiers = cashiers;
    }

    public Boolean getShared() {
        return this.shared;
    }

    public Boolean getControlCashierChoice() {
        return this.controlCashierChoice;
    }

    public String getExternalCode() {
        return this.externalCode;
    }

    public String getFrNumber() {
        return this.frNumber;
    }

    public Boolean getControlShippingStock() {
        return this.controlShippingStock;
    }

    public Boolean getOfdEnabled() {
        return this.ofdEnabled;
    }

    public Boolean getArchived() {
        return this.archived;
    }

    public Boolean getIssueOrders() {
        return this.issueOrders;
    }

    public List<LastOperationNamesItem> getLastOperationNames() {
        return this.lastOperationNames;
    }

    public RetailStoreState getState() {
        return this.state;
    }

    public Group getGroup() {
        return this.group;
    }

    public Employee getOwner() {
        return this.owner;
    }

    public Boolean getAllowCustomPrice() {
        return this.allowCustomPrice;
    }

    public PriceType getPriceType() {
        return this.priceType;
    }

    public ListEntity<Cashier> getCashiers() {
        return this.cashiers;
    }

    public Boolean getActive() {
        return this.active;
    }

    public Store getStore() {
        return this.store;
    }

    public Boolean getDiscountEnable() {
        return this.discountEnable;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public Boolean getSellReserves() {
        return this.sellReserves;
    }

    public Boolean getAuthTokenAttached() {
        return this.authTokenAttached;
    }

    public Boolean getEgaisEnabled() {
        return this.egaisEnabled;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public Integer getDiscountMaxPercent() {
        return this.discountMaxPercent;
    }

    public LocalDateTime getUpdated() {
        return this.updated;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAddress() {
        return this.address;
    }

    public Address getAddressFull() {
        return this.addressFull;
    }

    public Boolean getOnlyInStock() {
        return this.onlyInStock;
    }

    public Agent getAcquire() {
        return this.acquire;
    }

    public State getOrderToState() {
        return this.orderToState;
    }

    public List<State> getCustomerOrderStates() {
        return this.customerOrderStates;
    }

    public TaxSystem getDefaultTaxSystem() {
        return this.defaultTaxSystem;
    }

    public TaxSystem getOrderTaxSystem() {
        return this.orderTaxSystem;
    }

    public Boolean getAllowCreateProducts() {
        return this.allowCreateProducts;
    }

    public PriorityOfdSend getPriorityOfdSend() {
        return this.priorityOfdSend;
    }

    public String getDemandPrefix() {
        return this.demandPrefix;
    }

    public Boolean getAllowSellTobaccoWithoutMRC() {
        return this.allowSellTobaccoWithoutMRC;
    }

    public TobaccoMrcControlType getTobaccoMrcControlType() {
        return this.tobaccoMrcControlType;
    }

    public ListEntity<ProductFolder> getProductFolders() {
        return this.productFolders;
    }

    public List<String> getCreateAgentsTags() {
        return this.createAgentsTags;
    }

    public List<String> getFilterAgentsTags() {
        return this.filterAgentsTags;
    }

    public Boolean getPrintAlways() {
        return this.printAlways;
    }

    public ReceiptTemplate getReceiptTemplate() {
        return this.receiptTemplate;
    }

    public Boolean getCreatePaymentInOnRetailShiftClosing() {
        return this.createPaymentInOnRetailShiftClosing;
    }

    public Boolean getCreateCashInOnRetailShiftClosing() {
        return this.createCashInOnRetailShiftClosing;
    }

    public Boolean getReturnFromClosedShiftEnabled() {
        return this.returnFromClosedShiftEnabled;
    }

    public Boolean getEnableReturnsWithNoReason() {
        return this.enableReturnsWithNoReason;
    }

    public State getCreateOrderWithState() {
        return this.createOrderWithState;
    }

    public Boolean getReservePrepaidGoods() {
        return this.reservePrepaidGoods;
    }

    public Double getBankPercent() {
        return this.bankPercent;
    }

    public FiscalType getFiscalType() {
        return this.fiscalType;
    }

    public Boolean getQrPayEnabled() {
        return this.qrPayEnabled;
    }

    public Agent getQrAcquire() {
        return this.qrAcquire;
    }

    public MinionToMasterType getMinionToMasterType() {
        return this.minionToMasterType;
    }

    public ListEntity<RetailStore> getMasterRetailStores() {
        return this.masterRetailStores;
    }

    public Double getQrBankPercent() {
        return this.qrBankPercent;
    }

    public MarkingSellingMode getMarkingSellingMode() {
        return this.markingSellingMode;
    }

    public void setShared(Boolean shared) {
        this.shared = shared;
    }

    public void setControlCashierChoice(Boolean controlCashierChoice) {
        this.controlCashierChoice = controlCashierChoice;
    }

    public void setExternalCode(String externalCode) {
        this.externalCode = externalCode;
    }

    public void setFrNumber(String frNumber) {
        this.frNumber = frNumber;
    }

    public void setControlShippingStock(Boolean controlShippingStock) {
        this.controlShippingStock = controlShippingStock;
    }

    public void setOfdEnabled(Boolean ofdEnabled) {
        this.ofdEnabled = ofdEnabled;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public void setIssueOrders(Boolean issueOrders) {
        this.issueOrders = issueOrders;
    }

    public void setLastOperationNames(List<LastOperationNamesItem> lastOperationNames) {
        this.lastOperationNames = lastOperationNames;
    }

    public void setState(RetailStoreState state) {
        this.state = state;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public void setOwner(Employee owner) {
        this.owner = owner;
    }

    public void setAllowCustomPrice(Boolean allowCustomPrice) {
        this.allowCustomPrice = allowCustomPrice;
    }

    public void setPriceType(PriceType priceType) {
        this.priceType = priceType;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setStore(Store store) {
        this.store = store;
    }

    public void setDiscountEnable(Boolean discountEnable) {
        this.discountEnable = discountEnable;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setSellReserves(Boolean sellReserves) {
        this.sellReserves = sellReserves;
    }

    public void setAuthTokenAttached(Boolean authTokenAttached) {
        this.authTokenAttached = authTokenAttached;
    }

    public void setEgaisEnabled(Boolean egaisEnabled) {
        this.egaisEnabled = egaisEnabled;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public void setDiscountMaxPercent(Integer discountMaxPercent) {
        this.discountMaxPercent = discountMaxPercent;
    }

    public void setUpdated(LocalDateTime updated) {
        this.updated = updated;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setAddressFull(Address addressFull) {
        this.addressFull = addressFull;
    }

    public void setOnlyInStock(Boolean onlyInStock) {
        this.onlyInStock = onlyInStock;
    }

    public void setAcquire(Agent acquire) {
        this.acquire = acquire;
    }

    public void setOrderToState(State orderToState) {
        this.orderToState = orderToState;
    }

    public void setCustomerOrderStates(List<State> customerOrderStates) {
        this.customerOrderStates = customerOrderStates;
    }

    public void setDefaultTaxSystem(TaxSystem defaultTaxSystem) {
        this.defaultTaxSystem = defaultTaxSystem;
    }

    public void setOrderTaxSystem(TaxSystem orderTaxSystem) {
        this.orderTaxSystem = orderTaxSystem;
    }

    public void setAllowCreateProducts(Boolean allowCreateProducts) {
        this.allowCreateProducts = allowCreateProducts;
    }

    public void setPriorityOfdSend(PriorityOfdSend priorityOfdSend) {
        this.priorityOfdSend = priorityOfdSend;
    }

    public void setDemandPrefix(String demandPrefix) {
        this.demandPrefix = demandPrefix;
    }

    public void setAllowSellTobaccoWithoutMRC(Boolean allowSellTobaccoWithoutMRC) {
        this.allowSellTobaccoWithoutMRC = allowSellTobaccoWithoutMRC;
    }

    public void setTobaccoMrcControlType(TobaccoMrcControlType tobaccoMrcControlType) {
        this.tobaccoMrcControlType = tobaccoMrcControlType;
    }

    public void setProductFolders(ListEntity<ProductFolder> productFolders) {
        this.productFolders = productFolders;
    }

    public void setCreateAgentsTags(List<String> createAgentsTags) {
        this.createAgentsTags = createAgentsTags;
    }

    public void setFilterAgentsTags(List<String> filterAgentsTags) {
        this.filterAgentsTags = filterAgentsTags;
    }

    public void setPrintAlways(Boolean printAlways) {
        this.printAlways = printAlways;
    }

    public void setReceiptTemplate(ReceiptTemplate receiptTemplate) {
        this.receiptTemplate = receiptTemplate;
    }

    public void setCreatePaymentInOnRetailShiftClosing(Boolean createPaymentInOnRetailShiftClosing) {
        this.createPaymentInOnRetailShiftClosing = createPaymentInOnRetailShiftClosing;
    }

    public void setCreateCashInOnRetailShiftClosing(Boolean createCashInOnRetailShiftClosing) {
        this.createCashInOnRetailShiftClosing = createCashInOnRetailShiftClosing;
    }

    public void setReturnFromClosedShiftEnabled(Boolean returnFromClosedShiftEnabled) {
        this.returnFromClosedShiftEnabled = returnFromClosedShiftEnabled;
    }

    public void setEnableReturnsWithNoReason(Boolean enableReturnsWithNoReason) {
        this.enableReturnsWithNoReason = enableReturnsWithNoReason;
    }

    public void setCreateOrderWithState(State createOrderWithState) {
        this.createOrderWithState = createOrderWithState;
    }

    public void setReservePrepaidGoods(Boolean reservePrepaidGoods) {
        this.reservePrepaidGoods = reservePrepaidGoods;
    }

    public void setBankPercent(Double bankPercent) {
        this.bankPercent = bankPercent;
    }

    public void setFiscalType(FiscalType fiscalType) {
        this.fiscalType = fiscalType;
    }

    public void setQrPayEnabled(Boolean qrPayEnabled) {
        this.qrPayEnabled = qrPayEnabled;
    }

    public void setQrAcquire(Agent qrAcquire) {
        this.qrAcquire = qrAcquire;
    }

    public void setMinionToMasterType(MinionToMasterType minionToMasterType) {
        this.minionToMasterType = minionToMasterType;
    }

    public void setMasterRetailStores(ListEntity<RetailStore> masterRetailStores) {
        this.masterRetailStores = masterRetailStores;
    }

    public void setQrBankPercent(Double qrBankPercent) {
        this.qrBankPercent = qrBankPercent;
    }

    public void setMarkingSellingMode(MarkingSellingMode markingSellingMode) {
        this.markingSellingMode = markingSellingMode;
    }

    public RetailStore() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RetailStore)) {
            return false;
        }
        RetailStore other = (RetailStore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$shared = this.getShared();
        Boolean other$shared = other.getShared();
        if (this$shared == null ? other$shared != null : !((Object)this$shared).equals(other$shared)) {
            return false;
        }
        Boolean this$controlCashierChoice = this.getControlCashierChoice();
        Boolean other$controlCashierChoice = other.getControlCashierChoice();
        if (this$controlCashierChoice == null ? other$controlCashierChoice != null : !((Object)this$controlCashierChoice).equals(other$controlCashierChoice)) {
            return false;
        }
        String this$externalCode = this.getExternalCode();
        String other$externalCode = other.getExternalCode();
        if (this$externalCode == null ? other$externalCode != null : !this$externalCode.equals(other$externalCode)) {
            return false;
        }
        String this$frNumber = this.getFrNumber();
        String other$frNumber = other.getFrNumber();
        if (this$frNumber == null ? other$frNumber != null : !this$frNumber.equals(other$frNumber)) {
            return false;
        }
        Boolean this$controlShippingStock = this.getControlShippingStock();
        Boolean other$controlShippingStock = other.getControlShippingStock();
        if (this$controlShippingStock == null ? other$controlShippingStock != null : !((Object)this$controlShippingStock).equals(other$controlShippingStock)) {
            return false;
        }
        Boolean this$ofdEnabled = this.getOfdEnabled();
        Boolean other$ofdEnabled = other.getOfdEnabled();
        if (this$ofdEnabled == null ? other$ofdEnabled != null : !((Object)this$ofdEnabled).equals(other$ofdEnabled)) {
            return false;
        }
        Boolean this$archived = this.getArchived();
        Boolean other$archived = other.getArchived();
        if (this$archived == null ? other$archived != null : !((Object)this$archived).equals(other$archived)) {
            return false;
        }
        Boolean this$issueOrders = this.getIssueOrders();
        Boolean other$issueOrders = other.getIssueOrders();
        if (this$issueOrders == null ? other$issueOrders != null : !((Object)this$issueOrders).equals(other$issueOrders)) {
            return false;
        }
        List<LastOperationNamesItem> this$lastOperationNames = this.getLastOperationNames();
        List<LastOperationNamesItem> other$lastOperationNames = other.getLastOperationNames();
        if (this$lastOperationNames == null ? other$lastOperationNames != null : !((Object)this$lastOperationNames).equals(other$lastOperationNames)) {
            return false;
        }
        RetailStoreState this$state = this.getState();
        RetailStoreState other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        Group this$group = this.getGroup();
        Group other$group = other.getGroup();
        if (this$group == null ? other$group != null : !((Object)this$group).equals(other$group)) {
            return false;
        }
        Employee this$owner = this.getOwner();
        Employee other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Boolean this$allowCustomPrice = this.getAllowCustomPrice();
        Boolean other$allowCustomPrice = other.getAllowCustomPrice();
        if (this$allowCustomPrice == null ? other$allowCustomPrice != null : !((Object)this$allowCustomPrice).equals(other$allowCustomPrice)) {
            return false;
        }
        PriceType this$priceType = this.getPriceType();
        PriceType other$priceType = other.getPriceType();
        if (this$priceType == null ? other$priceType != null : !((Object)this$priceType).equals(other$priceType)) {
            return false;
        }
        ListEntity<Cashier> this$cashiers = this.getCashiers();
        ListEntity<Cashier> other$cashiers = other.getCashiers();
        if (this$cashiers == null ? other$cashiers != null : !((Object)this$cashiers).equals(other$cashiers)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Store this$store = this.getStore();
        Store other$store = other.getStore();
        if (this$store == null ? other$store != null : !((Object)this$store).equals(other$store)) {
            return false;
        }
        Boolean this$discountEnable = this.getDiscountEnable();
        Boolean other$discountEnable = other.getDiscountEnable();
        if (this$discountEnable == null ? other$discountEnable != null : !((Object)this$discountEnable).equals(other$discountEnable)) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        Boolean this$sellReserves = this.getSellReserves();
        Boolean other$sellReserves = other.getSellReserves();
        if (this$sellReserves == null ? other$sellReserves != null : !((Object)this$sellReserves).equals(other$sellReserves)) {
            return false;
        }
        Boolean this$authTokenAttached = this.getAuthTokenAttached();
        Boolean other$authTokenAttached = other.getAuthTokenAttached();
        if (this$authTokenAttached == null ? other$authTokenAttached != null : !((Object)this$authTokenAttached).equals(other$authTokenAttached)) {
            return false;
        }
        Boolean this$egaisEnabled = this.getEgaisEnabled();
        Boolean other$egaisEnabled = other.getEgaisEnabled();
        if (this$egaisEnabled == null ? other$egaisEnabled != null : !((Object)this$egaisEnabled).equals(other$egaisEnabled)) {
            return false;
        }
        Organization this$organization = this.getOrganization();
        Organization other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !((Object)this$organization).equals(other$organization)) {
            return false;
        }
        Integer this$discountMaxPercent = this.getDiscountMaxPercent();
        Integer other$discountMaxPercent = other.getDiscountMaxPercent();
        if (this$discountMaxPercent == null ? other$discountMaxPercent != null : !((Object)this$discountMaxPercent).equals(other$discountMaxPercent)) {
            return false;
        }
        LocalDateTime this$updated = this.getUpdated();
        LocalDateTime other$updated = other.getUpdated();
        if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Address this$addressFull = this.getAddressFull();
        Address other$addressFull = other.getAddressFull();
        if (this$addressFull == null ? other$addressFull != null : !this$addressFull.equals(other$addressFull)) {
            return false;
        }
        Boolean this$onlyInStock = this.getOnlyInStock();
        Boolean other$onlyInStock = other.getOnlyInStock();
        if (this$onlyInStock == null ? other$onlyInStock != null : !((Object)this$onlyInStock).equals(other$onlyInStock)) {
            return false;
        }
        Agent this$acquire = this.getAcquire();
        Agent other$acquire = other.getAcquire();
        if (this$acquire == null ? other$acquire != null : !((Object)this$acquire).equals(other$acquire)) {
            return false;
        }
        State this$orderToState = this.getOrderToState();
        State other$orderToState = other.getOrderToState();
        if (this$orderToState == null ? other$orderToState != null : !((Object)this$orderToState).equals(other$orderToState)) {
            return false;
        }
        List<State> this$customerOrderStates = this.getCustomerOrderStates();
        List<State> other$customerOrderStates = other.getCustomerOrderStates();
        if (this$customerOrderStates == null ? other$customerOrderStates != null : !((Object)this$customerOrderStates).equals(other$customerOrderStates)) {
            return false;
        }
        TaxSystem this$defaultTaxSystem = this.getDefaultTaxSystem();
        TaxSystem other$defaultTaxSystem = other.getDefaultTaxSystem();
        if (this$defaultTaxSystem == null ? other$defaultTaxSystem != null : !((Object)((Object)this$defaultTaxSystem)).equals((Object)other$defaultTaxSystem)) {
            return false;
        }
        TaxSystem this$orderTaxSystem = this.getOrderTaxSystem();
        TaxSystem other$orderTaxSystem = other.getOrderTaxSystem();
        if (this$orderTaxSystem == null ? other$orderTaxSystem != null : !((Object)((Object)this$orderTaxSystem)).equals((Object)other$orderTaxSystem)) {
            return false;
        }
        Boolean this$allowCreateProducts = this.getAllowCreateProducts();
        Boolean other$allowCreateProducts = other.getAllowCreateProducts();
        if (this$allowCreateProducts == null ? other$allowCreateProducts != null : !((Object)this$allowCreateProducts).equals(other$allowCreateProducts)) {
            return false;
        }
        PriorityOfdSend this$priorityOfdSend = this.getPriorityOfdSend();
        PriorityOfdSend other$priorityOfdSend = other.getPriorityOfdSend();
        if (this$priorityOfdSend == null ? other$priorityOfdSend != null : !((Object)((Object)this$priorityOfdSend)).equals((Object)other$priorityOfdSend)) {
            return false;
        }
        String this$demandPrefix = this.getDemandPrefix();
        String other$demandPrefix = other.getDemandPrefix();
        if (this$demandPrefix == null ? other$demandPrefix != null : !this$demandPrefix.equals(other$demandPrefix)) {
            return false;
        }
        Boolean this$allowSellTobaccoWithoutMRC = this.getAllowSellTobaccoWithoutMRC();
        Boolean other$allowSellTobaccoWithoutMRC = other.getAllowSellTobaccoWithoutMRC();
        if (this$allowSellTobaccoWithoutMRC == null ? other$allowSellTobaccoWithoutMRC != null : !((Object)this$allowSellTobaccoWithoutMRC).equals(other$allowSellTobaccoWithoutMRC)) {
            return false;
        }
        TobaccoMrcControlType this$tobaccoMrcControlType = this.getTobaccoMrcControlType();
        TobaccoMrcControlType other$tobaccoMrcControlType = other.getTobaccoMrcControlType();
        if (this$tobaccoMrcControlType == null ? other$tobaccoMrcControlType != null : !((Object)((Object)this$tobaccoMrcControlType)).equals((Object)other$tobaccoMrcControlType)) {
            return false;
        }
        ListEntity<ProductFolder> this$productFolders = this.getProductFolders();
        ListEntity<ProductFolder> other$productFolders = other.getProductFolders();
        if (this$productFolders == null ? other$productFolders != null : !((Object)this$productFolders).equals(other$productFolders)) {
            return false;
        }
        List<String> this$createAgentsTags = this.getCreateAgentsTags();
        List<String> other$createAgentsTags = other.getCreateAgentsTags();
        if (this$createAgentsTags == null ? other$createAgentsTags != null : !((Object)this$createAgentsTags).equals(other$createAgentsTags)) {
            return false;
        }
        List<String> this$filterAgentsTags = this.getFilterAgentsTags();
        List<String> other$filterAgentsTags = other.getFilterAgentsTags();
        if (this$filterAgentsTags == null ? other$filterAgentsTags != null : !((Object)this$filterAgentsTags).equals(other$filterAgentsTags)) {
            return false;
        }
        Boolean this$printAlways = this.getPrintAlways();
        Boolean other$printAlways = other.getPrintAlways();
        if (this$printAlways == null ? other$printAlways != null : !((Object)this$printAlways).equals(other$printAlways)) {
            return false;
        }
        ReceiptTemplate this$receiptTemplate = this.getReceiptTemplate();
        ReceiptTemplate other$receiptTemplate = other.getReceiptTemplate();
        if (this$receiptTemplate == null ? other$receiptTemplate != null : !((Object)this$receiptTemplate).equals(other$receiptTemplate)) {
            return false;
        }
        Boolean this$createPaymentInOnRetailShiftClosing = this.getCreatePaymentInOnRetailShiftClosing();
        Boolean other$createPaymentInOnRetailShiftClosing = other.getCreatePaymentInOnRetailShiftClosing();
        if (this$createPaymentInOnRetailShiftClosing == null ? other$createPaymentInOnRetailShiftClosing != null : !((Object)this$createPaymentInOnRetailShiftClosing).equals(other$createPaymentInOnRetailShiftClosing)) {
            return false;
        }
        Boolean this$createCashInOnRetailShiftClosing = this.getCreateCashInOnRetailShiftClosing();
        Boolean other$createCashInOnRetailShiftClosing = other.getCreateCashInOnRetailShiftClosing();
        if (this$createCashInOnRetailShiftClosing == null ? other$createCashInOnRetailShiftClosing != null : !((Object)this$createCashInOnRetailShiftClosing).equals(other$createCashInOnRetailShiftClosing)) {
            return false;
        }
        Boolean this$returnFromClosedShiftEnabled = this.getReturnFromClosedShiftEnabled();
        Boolean other$returnFromClosedShiftEnabled = other.getReturnFromClosedShiftEnabled();
        if (this$returnFromClosedShiftEnabled == null ? other$returnFromClosedShiftEnabled != null : !((Object)this$returnFromClosedShiftEnabled).equals(other$returnFromClosedShiftEnabled)) {
            return false;
        }
        Boolean this$enableReturnsWithNoReason = this.getEnableReturnsWithNoReason();
        Boolean other$enableReturnsWithNoReason = other.getEnableReturnsWithNoReason();
        if (this$enableReturnsWithNoReason == null ? other$enableReturnsWithNoReason != null : !((Object)this$enableReturnsWithNoReason).equals(other$enableReturnsWithNoReason)) {
            return false;
        }
        State this$createOrderWithState = this.getCreateOrderWithState();
        State other$createOrderWithState = other.getCreateOrderWithState();
        if (this$createOrderWithState == null ? other$createOrderWithState != null : !((Object)this$createOrderWithState).equals(other$createOrderWithState)) {
            return false;
        }
        Boolean this$reservePrepaidGoods = this.getReservePrepaidGoods();
        Boolean other$reservePrepaidGoods = other.getReservePrepaidGoods();
        if (this$reservePrepaidGoods == null ? other$reservePrepaidGoods != null : !((Object)this$reservePrepaidGoods).equals(other$reservePrepaidGoods)) {
            return false;
        }
        Double this$bankPercent = this.getBankPercent();
        Double other$bankPercent = other.getBankPercent();
        if (this$bankPercent == null ? other$bankPercent != null : !((Object)this$bankPercent).equals(other$bankPercent)) {
            return false;
        }
        FiscalType this$fiscalType = this.getFiscalType();
        FiscalType other$fiscalType = other.getFiscalType();
        if (this$fiscalType == null ? other$fiscalType != null : !((Object)((Object)this$fiscalType)).equals((Object)other$fiscalType)) {
            return false;
        }
        Boolean this$qrPayEnabled = this.getQrPayEnabled();
        Boolean other$qrPayEnabled = other.getQrPayEnabled();
        if (this$qrPayEnabled == null ? other$qrPayEnabled != null : !((Object)this$qrPayEnabled).equals(other$qrPayEnabled)) {
            return false;
        }
        Agent this$qrAcquire = this.getQrAcquire();
        Agent other$qrAcquire = other.getQrAcquire();
        if (this$qrAcquire == null ? other$qrAcquire != null : !((Object)this$qrAcquire).equals(other$qrAcquire)) {
            return false;
        }
        MinionToMasterType this$minionToMasterType = this.getMinionToMasterType();
        MinionToMasterType other$minionToMasterType = other.getMinionToMasterType();
        if (this$minionToMasterType == null ? other$minionToMasterType != null : !((Object)((Object)this$minionToMasterType)).equals((Object)other$minionToMasterType)) {
            return false;
        }
        ListEntity<RetailStore> this$masterRetailStores = this.getMasterRetailStores();
        ListEntity<RetailStore> other$masterRetailStores = other.getMasterRetailStores();
        if (this$masterRetailStores == null ? other$masterRetailStores != null : !((Object)this$masterRetailStores).equals(other$masterRetailStores)) {
            return false;
        }
        Double this$qrBankPercent = this.getQrBankPercent();
        Double other$qrBankPercent = other.getQrBankPercent();
        if (this$qrBankPercent == null ? other$qrBankPercent != null : !((Object)this$qrBankPercent).equals(other$qrBankPercent)) {
            return false;
        }
        MarkingSellingMode this$markingSellingMode = this.getMarkingSellingMode();
        MarkingSellingMode other$markingSellingMode = other.getMarkingSellingMode();
        return !(this$markingSellingMode == null ? other$markingSellingMode != null : !((Object)((Object)this$markingSellingMode)).equals((Object)other$markingSellingMode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RetailStore;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $shared = this.getShared();
        result = result * 59 + ($shared == null ? 43 : ((Object)$shared).hashCode());
        Boolean $controlCashierChoice = this.getControlCashierChoice();
        result = result * 59 + ($controlCashierChoice == null ? 43 : ((Object)$controlCashierChoice).hashCode());
        String $externalCode = this.getExternalCode();
        result = result * 59 + ($externalCode == null ? 43 : $externalCode.hashCode());
        String $frNumber = this.getFrNumber();
        result = result * 59 + ($frNumber == null ? 43 : $frNumber.hashCode());
        Boolean $controlShippingStock = this.getControlShippingStock();
        result = result * 59 + ($controlShippingStock == null ? 43 : ((Object)$controlShippingStock).hashCode());
        Boolean $ofdEnabled = this.getOfdEnabled();
        result = result * 59 + ($ofdEnabled == null ? 43 : ((Object)$ofdEnabled).hashCode());
        Boolean $archived = this.getArchived();
        result = result * 59 + ($archived == null ? 43 : ((Object)$archived).hashCode());
        Boolean $issueOrders = this.getIssueOrders();
        result = result * 59 + ($issueOrders == null ? 43 : ((Object)$issueOrders).hashCode());
        List<LastOperationNamesItem> $lastOperationNames = this.getLastOperationNames();
        result = result * 59 + ($lastOperationNames == null ? 43 : ((Object)$lastOperationNames).hashCode());
        RetailStoreState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        Group $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : ((Object)$group).hashCode());
        Employee $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Boolean $allowCustomPrice = this.getAllowCustomPrice();
        result = result * 59 + ($allowCustomPrice == null ? 43 : ((Object)$allowCustomPrice).hashCode());
        PriceType $priceType = this.getPriceType();
        result = result * 59 + ($priceType == null ? 43 : ((Object)$priceType).hashCode());
        ListEntity<Cashier> $cashiers = this.getCashiers();
        result = result * 59 + ($cashiers == null ? 43 : ((Object)$cashiers).hashCode());
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Store $store = this.getStore();
        result = result * 59 + ($store == null ? 43 : ((Object)$store).hashCode());
        Boolean $discountEnable = this.getDiscountEnable();
        result = result * 59 + ($discountEnable == null ? 43 : ((Object)$discountEnable).hashCode());
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        Boolean $sellReserves = this.getSellReserves();
        result = result * 59 + ($sellReserves == null ? 43 : ((Object)$sellReserves).hashCode());
        Boolean $authTokenAttached = this.getAuthTokenAttached();
        result = result * 59 + ($authTokenAttached == null ? 43 : ((Object)$authTokenAttached).hashCode());
        Boolean $egaisEnabled = this.getEgaisEnabled();
        result = result * 59 + ($egaisEnabled == null ? 43 : ((Object)$egaisEnabled).hashCode());
        Organization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : ((Object)$organization).hashCode());
        Integer $discountMaxPercent = this.getDiscountMaxPercent();
        result = result * 59 + ($discountMaxPercent == null ? 43 : ((Object)$discountMaxPercent).hashCode());
        LocalDateTime $updated = this.getUpdated();
        result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Address $addressFull = this.getAddressFull();
        result = result * 59 + ($addressFull == null ? 43 : $addressFull.hashCode());
        Boolean $onlyInStock = this.getOnlyInStock();
        result = result * 59 + ($onlyInStock == null ? 43 : ((Object)$onlyInStock).hashCode());
        Agent $acquire = this.getAcquire();
        result = result * 59 + ($acquire == null ? 43 : ((Object)$acquire).hashCode());
        State $orderToState = this.getOrderToState();
        result = result * 59 + ($orderToState == null ? 43 : ((Object)$orderToState).hashCode());
        List<State> $customerOrderStates = this.getCustomerOrderStates();
        result = result * 59 + ($customerOrderStates == null ? 43 : ((Object)$customerOrderStates).hashCode());
        TaxSystem $defaultTaxSystem = this.getDefaultTaxSystem();
        result = result * 59 + ($defaultTaxSystem == null ? 43 : ((Object)((Object)$defaultTaxSystem)).hashCode());
        TaxSystem $orderTaxSystem = this.getOrderTaxSystem();
        result = result * 59 + ($orderTaxSystem == null ? 43 : ((Object)((Object)$orderTaxSystem)).hashCode());
        Boolean $allowCreateProducts = this.getAllowCreateProducts();
        result = result * 59 + ($allowCreateProducts == null ? 43 : ((Object)$allowCreateProducts).hashCode());
        PriorityOfdSend $priorityOfdSend = this.getPriorityOfdSend();
        result = result * 59 + ($priorityOfdSend == null ? 43 : ((Object)((Object)$priorityOfdSend)).hashCode());
        String $demandPrefix = this.getDemandPrefix();
        result = result * 59 + ($demandPrefix == null ? 43 : $demandPrefix.hashCode());
        Boolean $allowSellTobaccoWithoutMRC = this.getAllowSellTobaccoWithoutMRC();
        result = result * 59 + ($allowSellTobaccoWithoutMRC == null ? 43 : ((Object)$allowSellTobaccoWithoutMRC).hashCode());
        TobaccoMrcControlType $tobaccoMrcControlType = this.getTobaccoMrcControlType();
        result = result * 59 + ($tobaccoMrcControlType == null ? 43 : ((Object)((Object)$tobaccoMrcControlType)).hashCode());
        ListEntity<ProductFolder> $productFolders = this.getProductFolders();
        result = result * 59 + ($productFolders == null ? 43 : ((Object)$productFolders).hashCode());
        List<String> $createAgentsTags = this.getCreateAgentsTags();
        result = result * 59 + ($createAgentsTags == null ? 43 : ((Object)$createAgentsTags).hashCode());
        List<String> $filterAgentsTags = this.getFilterAgentsTags();
        result = result * 59 + ($filterAgentsTags == null ? 43 : ((Object)$filterAgentsTags).hashCode());
        Boolean $printAlways = this.getPrintAlways();
        result = result * 59 + ($printAlways == null ? 43 : ((Object)$printAlways).hashCode());
        ReceiptTemplate $receiptTemplate = this.getReceiptTemplate();
        result = result * 59 + ($receiptTemplate == null ? 43 : ((Object)$receiptTemplate).hashCode());
        Boolean $createPaymentInOnRetailShiftClosing = this.getCreatePaymentInOnRetailShiftClosing();
        result = result * 59 + ($createPaymentInOnRetailShiftClosing == null ? 43 : ((Object)$createPaymentInOnRetailShiftClosing).hashCode());
        Boolean $createCashInOnRetailShiftClosing = this.getCreateCashInOnRetailShiftClosing();
        result = result * 59 + ($createCashInOnRetailShiftClosing == null ? 43 : ((Object)$createCashInOnRetailShiftClosing).hashCode());
        Boolean $returnFromClosedShiftEnabled = this.getReturnFromClosedShiftEnabled();
        result = result * 59 + ($returnFromClosedShiftEnabled == null ? 43 : ((Object)$returnFromClosedShiftEnabled).hashCode());
        Boolean $enableReturnsWithNoReason = this.getEnableReturnsWithNoReason();
        result = result * 59 + ($enableReturnsWithNoReason == null ? 43 : ((Object)$enableReturnsWithNoReason).hashCode());
        State $createOrderWithState = this.getCreateOrderWithState();
        result = result * 59 + ($createOrderWithState == null ? 43 : ((Object)$createOrderWithState).hashCode());
        Boolean $reservePrepaidGoods = this.getReservePrepaidGoods();
        result = result * 59 + ($reservePrepaidGoods == null ? 43 : ((Object)$reservePrepaidGoods).hashCode());
        Double $bankPercent = this.getBankPercent();
        result = result * 59 + ($bankPercent == null ? 43 : ((Object)$bankPercent).hashCode());
        FiscalType $fiscalType = this.getFiscalType();
        result = result * 59 + ($fiscalType == null ? 43 : ((Object)((Object)$fiscalType)).hashCode());
        Boolean $qrPayEnabled = this.getQrPayEnabled();
        result = result * 59 + ($qrPayEnabled == null ? 43 : ((Object)$qrPayEnabled).hashCode());
        Agent $qrAcquire = this.getQrAcquire();
        result = result * 59 + ($qrAcquire == null ? 43 : ((Object)$qrAcquire).hashCode());
        MinionToMasterType $minionToMasterType = this.getMinionToMasterType();
        result = result * 59 + ($minionToMasterType == null ? 43 : ((Object)((Object)$minionToMasterType)).hashCode());
        ListEntity<RetailStore> $masterRetailStores = this.getMasterRetailStores();
        result = result * 59 + ($masterRetailStores == null ? 43 : ((Object)$masterRetailStores).hashCode());
        Double $qrBankPercent = this.getQrBankPercent();
        result = result * 59 + ($qrBankPercent == null ? 43 : ((Object)$qrBankPercent).hashCode());
        MarkingSellingMode $markingSellingMode = this.getMarkingSellingMode();
        result = result * 59 + ($markingSellingMode == null ? 43 : ((Object)((Object)$markingSellingMode)).hashCode());
        return result;
    }

    public static enum MarkingSellingMode {
        CORRECT_MARKS_ONLY,
        WITHOUT_ERRORS,
        ALL;

    }

    public static enum TobaccoMrcControlType {
        USER_PRICE,
        MRC_PRICE,
        SAME_PRICE;

    }

    public static enum MinionToMasterType {
        ANY,
        SAME_GROUP,
        CHOSEN;

    }

    public static enum FiscalType {
        STANDARD,
        MASTER,
        CLOUD;

    }

    public static class CashiersSerializer
    implements JsonSerializer<ListEntity<Cashier>> {
        public JsonElement serialize(ListEntity<Cashier> src, Type typeOfSrc, JsonSerializationContext context) {
            if (src.getRows() == null) {
                return null;
            }
            return context.serialize(src.getRows().stream().map(Cashier::getEmployee).collect(Collectors.toList()));
        }
    }

    public static enum PriorityOfdSend {
        PHONE,
        EMAIL,
        NONE;

    }

    public static class PaymentTerminalState {
        private String acquiringType;

        public String getAcquiringType() {
            return this.acquiringType;
        }

        public void setAcquiringType(String acquiringType) {
            this.acquiringType = acquiringType;
        }
    }

    public static class RetailStoreState {
        private Sync sync;
        private LocalDateTime lastCheckMoment;
        private FiscalMemoryState fiscalMemory;
        private PaymentTerminalState paymentTerminal;

        public Sync getSync() {
            return this.sync;
        }

        public LocalDateTime getLastCheckMoment() {
            return this.lastCheckMoment;
        }

        public FiscalMemoryState getFiscalMemory() {
            return this.fiscalMemory;
        }

        public PaymentTerminalState getPaymentTerminal() {
            return this.paymentTerminal;
        }

        public void setSync(Sync sync) {
            this.sync = sync;
        }

        public void setLastCheckMoment(LocalDateTime lastCheckMoment) {
            this.lastCheckMoment = lastCheckMoment;
        }

        public void setFiscalMemory(FiscalMemoryState fiscalMemory) {
            this.fiscalMemory = fiscalMemory;
        }

        public void setPaymentTerminal(PaymentTerminalState paymentTerminal) {
            this.paymentTerminal = paymentTerminal;
        }

        public static class FiscalMemoryState {
            private Error error;
            private Integer notSendDocCount;
            private LocalDateTime notSendFirstDocMoment;

            public Error getError() {
                return this.error;
            }

            public Integer getNotSendDocCount() {
                return this.notSendDocCount;
            }

            public LocalDateTime getNotSendFirstDocMoment() {
                return this.notSendFirstDocMoment;
            }

            public void setError(Error error) {
                this.error = error;
            }

            public void setNotSendDocCount(Integer notSendDocCount) {
                this.notSendDocCount = notSendDocCount;
            }

            public void setNotSendFirstDocMoment(LocalDateTime notSendFirstDocMoment) {
                this.notSendFirstDocMoment = notSendFirstDocMoment;
            }

            public static class Error {
                private String code;
                private String message;

                public String getCode() {
                    return this.code;
                }

                public String getMessage() {
                    return this.message;
                }

                public void setCode(String code) {
                    this.code = code;
                }

                public void setMessage(String message) {
                    this.message = message;
                }
            }
        }

        public static class Sync {
            private String message;
            private String lastAttempMoment;

            public String getMessage() {
                return this.message;
            }

            public String getLastAttempMoment() {
                return this.lastAttempMoment;
            }

            public void setMessage(String message) {
                this.message = message;
            }

            public void setLastAttempMoment(String lastAttempMoment) {
                this.lastAttempMoment = lastAttempMoment;
            }
        }
    }

    public static class Environment {
        private String device;
        private String os;
        private Software software;
        private ChequePrinter chequePrinter;
        private PaymentTerminalState paymentTerminal;

        public String getDevice() {
            return this.device;
        }

        public String getOs() {
            return this.os;
        }

        public Software getSoftware() {
            return this.software;
        }

        public ChequePrinter getChequePrinter() {
            return this.chequePrinter;
        }

        public PaymentTerminalState getPaymentTerminal() {
            return this.paymentTerminal;
        }

        public void setDevice(String device) {
            this.device = device;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public void setSoftware(Software software) {
            this.software = software;
        }

        public void setChequePrinter(ChequePrinter chequePrinter) {
            this.chequePrinter = chequePrinter;
        }

        public void setPaymentTerminal(PaymentTerminalState paymentTerminal) {
            this.paymentTerminal = paymentTerminal;
        }

        public static class ChequePrinter {
            private String vendor;
            private String name;
            private String serial;
            private String fiscalDataVersion;
            private Driver driver;
            private FiscalMemory fiscalMemory;
            private String firmwareVersion;

            public String getVendor() {
                return this.vendor;
            }

            public String getName() {
                return this.name;
            }

            public String getSerial() {
                return this.serial;
            }

            public String getFiscalDataVersion() {
                return this.fiscalDataVersion;
            }

            public Driver getDriver() {
                return this.driver;
            }

            public FiscalMemory getFiscalMemory() {
                return this.fiscalMemory;
            }

            public String getFirmwareVersion() {
                return this.firmwareVersion;
            }

            public void setVendor(String vendor) {
                this.vendor = vendor;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setSerial(String serial) {
                this.serial = serial;
            }

            public void setFiscalDataVersion(String fiscalDataVersion) {
                this.fiscalDataVersion = fiscalDataVersion;
            }

            public void setDriver(Driver driver) {
                this.driver = driver;
            }

            public void setFiscalMemory(FiscalMemory fiscalMemory) {
                this.fiscalMemory = fiscalMemory;
            }

            public void setFirmwareVersion(String firmwareVersion) {
                this.firmwareVersion = firmwareVersion;
            }

            public class FiscalMemory {
                private String fiscalDataVersion;

                public String getFiscalDataVersion() {
                    return this.fiscalDataVersion;
                }

                public void setFiscalDataVersion(String fiscalDataVersion) {
                    this.fiscalDataVersion = fiscalDataVersion;
                }
            }

            public class Driver {
                private String name;
                private String version;

                public String getName() {
                    return this.name;
                }

                public String getVersion() {
                    return this.version;
                }

                public void setName(String name) {
                    this.name = name;
                }

                public void setVersion(String version) {
                    this.version = version;
                }
            }
        }

        public static class Software {
            private String name;
            private String vendor;
            private String version;

            public String getName() {
                return this.name;
            }

            public String getVendor() {
                return this.vendor;
            }

            public String getVersion() {
                return this.version;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setVendor(String vendor) {
                this.vendor = vendor;
            }

            public void setVersion(String version) {
                this.version = version;
            }
        }
    }

    public static class LastOperationNamesItem {
        private String name;
        private Meta.Type entity;

        public String getName() {
            return this.name;
        }

        public Meta.Type getEntity() {
            return this.entity;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setEntity(Meta.Type entity) {
            this.entity = entity;
        }
    }
}

