/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.discounts.AccumulationDiscount;
import ru.moysklad.remap_1_2.entities.discounts.BonusProgram;
import ru.moysklad.remap_1_2.entities.discounts.Discount;
import ru.moysklad.remap_1_2.entities.discounts.PersonalDiscount;
import ru.moysklad.remap_1_2.entities.discounts.RoundOffDiscount;
import ru.moysklad.remap_1_2.entities.discounts.SpecialPriceDiscount;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class DiscountDeserializer
implements JsonDeserializer<Discount> {
    private final Gson gson = JsonUtils.createGsonWithMetaAdapter();

    public Discount deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        MetaEntity me = (MetaEntity)this.gson.fromJson(json, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException("Can't parse field 'discount': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException("Can't parse field 'discount': meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case ACCUMULATION_DISCOUNT: {
                return (Discount)context.deserialize(json, AccumulationDiscount.class);
            }
            case BONUS_PROGRAM: {
                return (Discount)context.deserialize(json, BonusProgram.class);
            }
            case DISCOUNT: {
                return (Discount)this.gson.fromJson(json, Discount.class);
            }
            case PERSONAL_DISCOUNT: {
                return (Discount)context.deserialize(json, PersonalDiscount.class);
            }
            case SPECIAL_PRICE_DISCOUNT: {
                return (Discount)context.deserialize(json, SpecialPriceDiscount.class);
            }
            case ROUND_OFF_DISCOUNT: {
                return (Discount)context.deserialize(json, RoundOffDiscount.class);
            }
        }
        throw new JsonParseException("Can't parse field 'discount': meta.type must be one of [accumulationdiscount, bonusprogram, discount, personaldiscount, specialpricediscount, roundoffdiscount]");
    }
}

