/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.clients.endpoints;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import ru.moysklad.remap_1_2.clients.endpoints.ApiEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.Endpoint;
import ru.moysklad.remap_1_2.entities.AttachedFile;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.HttpRequestExecutor;
import ru.moysklad.remap_1_2.utils.params.ApiParam;

public interface HasFilesEndpoint<T extends MetaEntity>
extends Endpoint {
    @ApiEndpoint
    default public ListEntity<AttachedFile> getFiles(String entityId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + entityId + "/files").apiParams(params).list(AttachedFile.class);
    }

    @ApiEndpoint
    default public ListEntity<AttachedFile> getFiles(T entity, ApiParam ... params) throws IOException, ApiClientException {
        return this.getFiles((T)((MetaEntity)entity).getId(), params);
    }

    @ApiEndpoint
    default public List<AttachedFile> addFile(String entityId, AttachedFile file) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + entityId + "/files").body(file).postList(AttachedFile.class);
    }

    @ApiEndpoint
    default public List<AttachedFile> addFile(T entity, AttachedFile file) throws IOException, ApiClientException {
        return this.addFile((T)((MetaEntity)entity).getId(), file);
    }

    @ApiEndpoint
    default public List<AttachedFile> updateFiles(String entityId, List<AttachedFile> files) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + entityId + "/files").body(files).postList(AttachedFile.class);
    }

    @ApiEndpoint
    default public List<AttachedFile> updateFiles(T entity, List<AttachedFile> files) throws IOException, ApiClientException {
        return this.updateFiles((T)((MetaEntity)entity).getId(), files);
    }

    @ApiEndpoint
    default public void deleteFile(String entityId, String fileId) throws IOException, ApiClientException {
        HttpRequestExecutor.path(this.api(), this.path() + entityId + "/files/" + fileId).delete();
    }

    @ApiEndpoint
    default public void deleteFile(T entity, String fileId) throws IOException, ApiClientException {
        this.deleteFile(((MetaEntity)entity).getId(), fileId);
    }

    @ApiEndpoint
    default public void deleteFile(String entityId, AttachedFile file) throws IOException, ApiClientException {
        if (Objects.isNull(file.getId())) {
            String href = file.getMeta().getHref();
            String fileId = href.substring(href.indexOf("files/") + "files/".length());
            this.deleteFile(entityId, fileId);
        } else {
            this.deleteFile(entityId, file.getId());
        }
    }

    @ApiEndpoint
    default public void deleteFile(T entity, AttachedFile file) throws IOException, ApiClientException {
        this.deleteFile(((MetaEntity)entity).getId(), file);
    }

    @ApiEndpoint
    default public void deleteFiles(String entityId, List<AttachedFile> files) throws IOException, ApiClientException {
        HttpRequestExecutor.path(this.api(), this.path() + entityId + "/files/delete").body(files).postList(AttachedFile.class);
    }

    @ApiEndpoint
    default public void deleteFiles(T entity, List<AttachedFile> files) throws IOException, ApiClientException {
        this.deleteFiles((T)((MetaEntity)entity).getId(), files);
    }
}

