/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.moysklad.remap_1_2.ApiClient;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.responses.ErrorResponse;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.params.ApiParam;

public final class HttpRequestExecutor {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestExecutor.class);
    private static final Base64.Encoder b64enc = Base64.getEncoder();
    private static Charset queryParamsCharset = Charset.forName("UTF-8");
    private final String hostApiPath;
    private final String url;
    private List<ApiParam> apiParams;
    private Map<String, Object> query;
    private Map<String, Object> headers;
    private final Gson gson;
    private final CloseableHttpClient client;
    private Object body;

    private HttpRequestExecutor(ApiClient api, String url) {
        if (api == null) {
            throw new IllegalArgumentException("\u0414\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a API \u043d\u0443\u0436\u0435\u043d \u043f\u0440\u043e\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 ApiClient!");
        }
        this.client = api.getClient();
        this.hostApiPath = api.getHost() + "/api/remap/1.2";
        this.url = this.hostApiPath + url;
        this.query = new HashMap<String, Object>();
        this.headers = new HashMap<String, Object>();
        this.body = null;
        this.auth(api);
        if (api.isPrettyPrintJson()) {
            this.header("Lognex-Pretty-Print-JSON", "true");
        }
        if (api.isPricePrecision()) {
            this.header("X-Lognex-Precision", "true");
        }
        if (api.isWithoutWebhookContent()) {
            this.header("X-Lognex-WebHook-Disable", "true");
        }
        this.gson = ApiClient.createGson();
    }

    private HttpRequestExecutor(CloseableHttpClient client, String url) {
        if (client == null) {
            throw new IllegalArgumentException("\u0414\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043d\u0443\u0436\u0435\u043d \u043f\u0440\u043e\u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u044d\u043a\u0437\u0435\u043c\u043f\u043b\u044f\u0440 CloseableHttpClient!");
        }
        this.client = client;
        this.hostApiPath = "";
        this.url = url;
        this.query = new HashMap<String, Object>();
        this.headers = new HashMap<String, Object>();
        this.body = null;
        this.gson = ApiClient.createGson();
    }

    public static void setQueryParamsCharset(Charset queryParamsCharset) {
        HttpRequestExecutor.queryParamsCharset = queryParamsCharset;
    }

    public static HttpRequestExecutor url(ApiClient api, String url) {
        return new HttpRequestExecutor(api.getClient(), url).auth(api);
    }

    public static HttpRequestExecutor path(ApiClient api, String path) {
        return new HttpRequestExecutor(api, path);
    }

    private HttpRequestExecutor auth(ApiClient api) {
        if (!StringUtils.isBlank((CharSequence)api.getToken())) {
            return this.header("Authorization", "Bearer " + api.getToken());
        }
        return this.header("Authorization", "Basic " + b64enc.encodeToString((api.getLogin() + ":" + api.getPassword()).getBytes()));
    }

    public HttpRequestExecutor query(String key, Object value) {
        if (this.query == null) {
            this.query = new HashMap<String, Object>();
        }
        this.query.put(key, value);
        return this;
    }

    public HttpRequestExecutor header(String key, Object value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>();
        }
        this.headers.put(key, value);
        return this;
    }

    public HttpRequestExecutor apiParams(ApiParam ... params) {
        if (params != null && params.length > 0) {
            if (this.apiParams == null) {
                this.apiParams = new ArrayList<ApiParam>();
            }
            Collections.addAll(this.apiParams, params);
        }
        return this;
    }

    public HttpRequestExecutor body(Object o) {
        this.body = o;
        return this;
    }

    private String getFullUrl() {
        if (this.apiParams != null && !this.apiParams.isEmpty()) {
            Map<ApiParam.Type, List<ApiParam>> pm = this.apiParams.stream().collect(Collectors.groupingBy(ApiParam::getType));
            for (Map.Entry<Object, Object> entry : pm.entrySet()) {
                this.query(((ApiParam.Type)((Object)entry.getKey())).name(), ApiParam.renderStringQueryFromList((ApiParam.Type)((Object)entry.getKey()), (List)entry.getValue(), this.hostApiPath));
            }
        }
        if (this.query == null || this.query.isEmpty()) {
            return this.url;
        }
        StringBuilder queryBuilder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : this.query.entrySet()) {
            if (queryBuilder.length() != 0) {
                queryBuilder.append("&");
            }
            try {
                queryBuilder.append(URLEncoder.encode((String)entry.getKey(), queryParamsCharset.name())).append("=").append(URLEncoder.encode(String.valueOf(entry.getValue()), queryParamsCharset.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return this.url + (queryBuilder.length() == 0 ? "" : "?" + queryBuilder.toString());
    }

    private void applyHeaders(HttpUriRequest request) {
        for (Map.Entry<String, Object> e : this.headers.entrySet()) {
            request.setHeader(e.getKey(), String.valueOf(e.getValue()));
        }
    }

    private String executeRequest(HttpUriRequest request) throws IOException, ApiClientException {
        logger.debug("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430  {} {}...", (Object)request.getMethod(), (Object)request.getURI());
        try (CloseableHttpResponse response = this.client.execute(request);){
            String json;
            String string = json = response.getStatusLine().getStatusCode() == 204 ? "" : EntityUtils.toString((HttpEntity)response.getEntity());
            if (!this.isOkResponse(response)) {
                logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 {} {}: ({}) {}", new Object[]{request.getMethod(), request.getURI(), response.getStatusLine().getStatusCode(), json});
                ErrorResponse er = (ErrorResponse)this.gson.fromJson(json, ErrorResponse.class);
                throw new ApiClientException(request.getMethod() + " " + request.getURI(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), er);
            }
            logger.debug("\u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441     {} {}: ({}) {}", new Object[]{request.getMethod(), request.getURI(), response.getStatusLine().getStatusCode(), json});
            String string2 = json;
            return string2;
        }
    }

    private byte[] executeByteRequest(HttpUriRequest request) throws IOException, ApiClientException {
        logger.debug("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430  {} {}...", (Object)request.getMethod(), (Object)request.getURI());
        try (CloseableHttpResponse response = this.client.execute(request);){
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
            if (!this.isOkResponse(response)) {
                String json = new String(bytes);
                logger.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043f\u0440\u043e\u0441\u0435 {} {}: ({}) {}", new Object[]{request.getMethod(), request.getURI(), response.getStatusLine().getStatusCode(), json});
                ErrorResponse er = (ErrorResponse)this.gson.fromJson(json, ErrorResponse.class);
                throw new ApiClientException(request.getMethod() + " " + request.getURI(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), er);
            }
            logger.debug("\u041e\u0442\u0432\u0435\u0442 \u043d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441     {} {}: ({}) [bytes...]", new Object[]{request.getMethod(), request.getURI(), response.getStatusLine().getStatusCode()});
            byte[] byArray = bytes;
            return byArray;
        }
    }

    private boolean isOkResponse(CloseableHttpResponse response) {
        int statusCode = response.getStatusLine().getStatusCode();
        return statusCode == 200 || statusCode == 201 || statusCode == 204;
    }

    public String get() throws IOException, ApiClientException {
        HttpGet request = new HttpGet(this.getFullUrl());
        this.applyHeaders((HttpUriRequest)request);
        return this.executeRequest((HttpUriRequest)request);
    }

    public <T> T get(Class<T> cl) throws IOException, ApiClientException {
        return (T)this.gson.fromJson(this.get(), cl);
    }

    public <T extends MetaEntity> ListEntity<T> list(Class<T> cl) throws IOException, ApiClientException {
        return (ListEntity)this.gson.fromJson(this.get(), TypeToken.getParameterized(ListEntity.class, (Type[])new Type[]{cl}).getType());
    }

    public <T extends MetaEntity> List<T> plainList(Class<T> cl) throws IOException, ApiClientException {
        return (List)this.gson.fromJson(this.get(), TypeToken.getParameterized(List.class, (Type[])new Type[]{cl}).getType());
    }

    public String post() throws IOException, ApiClientException {
        HttpPost request = new HttpPost(this.getFullUrl());
        this.applyHeaders((HttpUriRequest)request);
        if (this.body != null) {
            String strBody = this.gson.toJson(this.body);
            logger.debug("\u0422\u0435\u043b\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430        {} {}: {}", new Object[]{request.getMethod(), request.getURI(), strBody});
            StringEntity requestEntity = new StringEntity(strBody, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)requestEntity);
        }
        return this.executeRequest((HttpUriRequest)request);
    }

    public File postAndSaveTo(File file) throws IOException, ApiClientException {
        HttpPost request = new HttpPost(this.getFullUrl());
        this.applyHeaders((HttpUriRequest)request);
        if (this.body != null) {
            String strBody = this.gson.toJson(this.body);
            logger.debug("\u0422\u0435\u043b\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430        {} {}: {}", new Object[]{request.getMethod(), request.getURI(), strBody});
            StringEntity requestEntity = new StringEntity(strBody, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)requestEntity);
        }
        byte[] data = this.executeByteRequest((HttpUriRequest)request);
        FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        return file;
    }

    public <T> T post(Class<T> cl) throws IOException, ApiClientException {
        return (T)this.gson.fromJson(this.post(), cl);
    }

    public <T> List<T> postList(Class<T> cl) throws IOException, ApiClientException {
        return (List)this.gson.fromJson(this.post(), TypeToken.getParameterized(List.class, (Type[])new Type[]{cl}).getType());
    }

    public void delete() throws IOException, ApiClientException {
        HttpDelete request = new HttpDelete(this.getFullUrl());
        this.applyHeaders((HttpUriRequest)request);
        this.executeRequest((HttpUriRequest)request);
    }

    public String put() throws IOException, ApiClientException {
        HttpPut request = new HttpPut(this.getFullUrl());
        this.applyHeaders((HttpUriRequest)request);
        if (this.body != null) {
            String strBody = this.gson.toJson(this.body);
            logger.debug("\u0422\u0435\u043b\u043e \u0437\u0430\u043f\u0440\u043e\u0441\u0430        {} {}: {}", new Object[]{request.getMethod(), request.getURI(), strBody});
            StringEntity requestEntity = new StringEntity(strBody, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)requestEntity);
        }
        return this.executeRequest((HttpUriRequest)request);
    }

    public <T> T put(Class<? extends T> cl) throws IOException, ApiClientException {
        return (T)this.gson.fromJson(this.put(), cl);
    }
}

