/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import ru.moysklad.remap_1_2.entities.Attribute;
import ru.moysklad.remap_1_2.entities.CustomEntityElement;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.Template;

public final class MetaHrefUtils {
    public static Optional<String> getIdFromHref(String href) {
        String[] split = href.split("/");
        return split.length == 0 ? Optional.empty() : Optional.of(split[split.length - 1]);
    }

    public static <T extends MetaEntity> String makeHref(Meta.Type type, T entity, String host) {
        if (type == null || entity == null || host == null) {
            return null;
        }
        String id = entity.getId();
        if (id == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(host);
        if (type == Meta.Type.PRICE_TYPE) {
            sb.append("/context/companysettings");
        } else {
            sb.append("/entity");
        }
        switch (type) {
            case CUSTOM_TEMPLATE: 
            case EMBEDDED_TEMPLATE: {
                Meta.Type entityType = ((Template)entity).getEntityType();
                if (entityType == null) {
                    return null;
                }
                sb.append('/').append(entityType.getApiName()).append('/').append("metadata");
                break;
            }
            case ATTRIBUTE_METADATA: {
                if (((Attribute)entity).getAttributeEntityType() == null) {
                    return null;
                }
                sb.append('/').append(((Attribute)entity).getAttributeEntityType().getApiName()).append("/metadata/attributes");
            }
        }
        sb.append('/');
        switch (type) {
            case CUSTOM_ENTITY: {
                sb.append(type.getApiName());
                if (((CustomEntityElement)entity).getCustomDictionaryId() == null) {
                    return null;
                }
                sb.append('/').append(((CustomEntityElement)entity).getCustomDictionaryId()).append('/');
                break;
            }
            case ATTRIBUTE_METADATA: {
                break;
            }
            default: {
                sb.append(type.getApiName()).append('/');
            }
        }
        return sb.append(id).toString();
    }

    public static <T extends MetaEntity> String makeMetadataHref(Meta.Type type, T entity, String host) {
        if (type != null && entity != null && host != null) {
            return host + "/entity/" + type.getApiName() + "/metadata";
        }
        return null;
    }

    public static String getCustomDictionaryIdFromHref(String href) {
        if (StringUtils.isEmpty((CharSequence)href)) {
            return null;
        }
        String[] hrefSplit = href.split("/");
        if (hrefSplit.length < 2 || !href.contains("/entity/customentity/") || hrefSplit[hrefSplit.length - 2].equals("customentity")) {
            return null;
        }
        return hrefSplit[hrefSplit.length - 2];
    }

    public static <T extends MetaEntity> T fillMeta(T entity, String host) {
        if (entity != null && entity.getClass() != MetaEntity.class) {
            if (entity.getId() != null && entity.getMeta() == null) {
                entity.setMeta(new Meta(entity, host));
            }
            Class<?> clazz = entity.getClass();
            List<MetaEntity> fields = MetaHrefUtils.getAllMetaFields(clazz, entity);
            fields.addAll(MetaHrefUtils.getAllListMetaFields(clazz, entity));
            fields.forEach(f -> f.setMeta(new Meta((MetaEntity)f, host)));
        }
        return entity;
    }

    private static <T extends MetaEntity> List<MetaEntity> getAllMetaFields(Class<?> clazz, T entity) {
        if (clazz == null || entity == null || clazz == MetaEntity.class) {
            return Collections.emptyList();
        }
        ArrayList<MetaEntity> result = new ArrayList<MetaEntity>(MetaHrefUtils.getAllMetaFields(clazz.getSuperclass(), entity));
        List filteredFields = Arrays.stream(clazz.getDeclaredFields()).filter(f -> MetaEntity.class.isAssignableFrom(f.getType())).map(f -> (MetaEntity)MetaHrefUtils.getFieldValueByName(f, clazz, entity)).filter(f -> f != null && StringUtils.isNotEmpty((CharSequence)f.getId()) && f.getMeta() == null).collect(Collectors.toList());
        result.addAll(filteredFields);
        return result;
    }

    private static <T extends MetaEntity> Object getFieldValueByName(Field f, Class<?> clazz, T entity) {
        try {
            String fieldName = f.getName().substring(0, 1).toUpperCase() + f.getName().substring(1);
            return clazz.getDeclaredMethod("get" + fieldName, new Class[0]).invoke(entity, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot access getter for field " + f.getName() + " of class " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot invoke getter for field " + f.getName() + " of class " + clazz.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot find getter for field " + f.getName() + " of class " + clazz.getName(), e);
        }
    }

    private static <T extends MetaEntity> List<MetaEntity> getAllListMetaFields(Class<?> clazz, T entity) {
        if (clazz == null || entity == null) {
            return Collections.emptyList();
        }
        Field[] fields = clazz.getDeclaredFields();
        return Arrays.stream(fields).filter(f -> List.class.isAssignableFrom(f.getType())).map(f -> (List)MetaHrefUtils.getFieldValueByName(f, clazz, entity)).flatMap(f -> {
            if (f != null && f.size() > 0 && MetaEntity.class.isAssignableFrom(f.get(0).getClass())) {
                return f.stream();
            }
            return Stream.empty();
        }).filter(f -> f != null && StringUtils.isNotEmpty((CharSequence)f.getId()) && f.getMeta() == null).collect(Collectors.toList());
    }

    private MetaHrefUtils() {
    }
}

