/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.agents.Agent;
import ru.moysklad.remap_1_2.entities.agents.Counterparty;
import ru.moysklad.remap_1_2.entities.agents.Employee;
import ru.moysklad.remap_1_2.entities.agents.Organization;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class AgentDeserializer
implements JsonDeserializer<Agent> {
    private final Gson gson = JsonUtils.createGsonWithMetaAdapter();

    public Agent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        MetaEntity me = (MetaEntity)this.gson.fromJson(json, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException("Can't parse field 'agent': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException("Can't parse field 'agent': meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case ORGANIZATION: {
                return (Agent)context.deserialize(json, Organization.class);
            }
            case COUNTERPARTY: {
                return (Agent)context.deserialize(json, Counterparty.class);
            }
            case EMPLOYEE: {
                return (Agent)context.deserialize(json, Employee.class);
            }
        }
        throw new JsonParseException("Can't parse field 'agent': meta.type must be one of [organization, counterparty, employee]");
    }
}

