/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import ru.moysklad.remap_1_2.entities.CustomEntity;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.responses.metadata.CompanySettingsMetadata;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class CustomEntityMetadataDeserializer
implements JsonDeserializer<CompanySettingsMetadata.CustomEntityMetadata> {
    private final Gson gson = JsonUtils.createGsonWithMetaAdapter();

    public CompanySettingsMetadata.CustomEntityMetadata deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        CompanySettingsMetadata.CustomEntityMetadata cem = new CompanySettingsMetadata.CustomEntityMetadata();
        JsonObject jo = json.getAsJsonObject();
        cem.setMeta((Meta)this.gson.fromJson(jo.get("meta"), Meta.class));
        String name = jo.get("name").getAsString();
        cem.setName(name);
        cem.setCreateShared(jo.get("createShared").getAsBoolean());
        CustomEntity entityMeta = new CustomEntity();
        entityMeta.setName(name);
        entityMeta.setMeta((Meta)this.gson.fromJson(jo.get("entityMeta"), Meta.class));
        if (entityMeta.getMeta().getHref() == null) {
            throw new JsonParseException("Can't parse field 'entityMeta': href is null");
        }
        String[] hrefSplit = entityMeta.getMeta().getHref().split("/");
        entityMeta.setId(hrefSplit[hrefSplit.length - 1]);
        cem.setEntityMeta(entityMeta);
        return cem;
    }
}

