/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.notifications.Notification;
import ru.moysklad.remap_1_2.entities.notifications.NotificationCustomerOrder;
import ru.moysklad.remap_1_2.entities.notifications.NotificationExchange;
import ru.moysklad.remap_1_2.entities.notifications.NotificationGoodCountTooLow;
import ru.moysklad.remap_1_2.entities.notifications.NotificationInvoiceOutOverdue;
import ru.moysklad.remap_1_2.entities.notifications.NotificationRetailShift;
import ru.moysklad.remap_1_2.entities.notifications.NotificationRetailShiftClosed;
import ru.moysklad.remap_1_2.entities.notifications.NotificationSubscribeExpired;
import ru.moysklad.remap_1_2.entities.notifications.NotificationSubscribeTermsExpired;
import ru.moysklad.remap_1_2.entities.notifications.NotificationTask;
import ru.moysklad.remap_1_2.entities.notifications.NotificationTaskChanged;
import ru.moysklad.remap_1_2.entities.notifications.NotificationTaskComment;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class NotificationDeserializer
implements JsonDeserializer<Notification> {
    private final Gson gson = JsonUtils.createGsonWithMetaAdapter();

    public Notification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        MetaEntity me = (MetaEntity)this.gson.fromJson(json, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException("Can't parse notification: meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException("Can't parse notification: meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case NOTIFICATION_ORDER_NEW: 
            case NOTIFICATION_ORDER_OVERDUE: {
                return (Notification)context.deserialize(json, NotificationCustomerOrder.class);
            }
            case NOTIFICATION_INVOICE_OUT_OVERDUE: {
                return (Notification)context.deserialize(json, NotificationInvoiceOutOverdue.class);
            }
            case NOTIFICATION_GOOD_COUNT_TOO_LOW: {
                return (Notification)context.deserialize(json, NotificationGoodCountTooLow.class);
            }
            case NOTIFICATION_TASK_ASSIGNED: 
            case NOTIFICATION_TASK_UNASSIGNED: 
            case NOTIFICATION_TASK_OVERDUE: 
            case NOTIFICATION_TASK_COMPLETED: 
            case NOTIFICATION_TASK_REOPENED: 
            case NOTIFICATION_TASK_DELETED: {
                return (Notification)context.deserialize(json, NotificationTask.class);
            }
            case NOTIFICATION_TASK_CHANGED: 
            case NOTIFICATION_TASK_COMMENT_CHANGED: {
                return (Notification)context.deserialize(json, NotificationTaskChanged.class);
            }
            case NOTIFICATION_TASK_COMMENT_DELETED: 
            case NOTIFICATION_TASK_NEW_COMMENT: {
                return (Notification)context.deserialize(json, NotificationTaskComment.class);
            }
            case NOTIFICATION_IMPORT_COMPLETED: 
            case NOTIFICATION_EXPORT_COMPLETED: {
                return (Notification)context.deserialize(json, NotificationExchange.class);
            }
            case NOTIFICATION_SUBSCRIBE_EXPIRED: {
                return (Notification)context.deserialize(json, NotificationSubscribeExpired.class);
            }
            case NOTIFICATION_SUBSCRIBE_TERMS_EXPIRED: {
                return (Notification)context.deserialize(json, NotificationSubscribeTermsExpired.class);
            }
            case NOTIFICATION_RETAIL_SHIFT_OPENED: {
                return (Notification)context.deserialize(json, NotificationRetailShift.class);
            }
            case NOTIFICATION_RETAIL_SHIFT_CLOSED: {
                return (Notification)context.deserialize(json, NotificationRetailShiftClosed.class);
            }
        }
        throw new JsonParseException("Can't parse notification: meta.type must be one of \"Notification*\"");
    }
}

