/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.clients.endpoints;

import java.io.IOException;
import ru.moysklad.remap_1_2.clients.endpoints.ApiEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.Endpoint;
import ru.moysklad.remap_1_2.entities.Publication;
import ru.moysklad.remap_1_2.entities.Template;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.HttpRequestExecutor;

public interface PublicationEndpoint
extends Endpoint {
    @ApiEndpoint
    default public ListEntity<Publication> getPublications(String documentId) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + documentId + "/publication/").list(Publication.class);
    }

    @ApiEndpoint
    default public Publication getPublication(String documentId, String publicationId) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + documentId + "/publication/" + publicationId).get(Publication.class);
    }

    @ApiEndpoint
    default public Publication publish(String documentId, Template template) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + documentId + "/publication/").body(new PublicationPayload(template)).post(Publication.class);
    }

    @ApiEndpoint
    default public void delelePublication(String documentId, String publicationId) throws IOException, ApiClientException {
        HttpRequestExecutor.path(this.api(), this.path() + documentId + "/publication/" + publicationId).delete();
    }

    public static class PublicationPayload {
        private Template template;

        PublicationPayload(Template template) {
            this.template = template;
        }

        public Template getTemplate() {
            return this.template;
        }

        public void setTemplate(Template template) {
            this.template = template;
        }

        public PublicationPayload() {
        }
    }
}

