/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.LocalDateTime;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import ru.moysklad.remap_1_2.clients.EntityClient;
import ru.moysklad.remap_1_2.clients.NotificationClient;
import ru.moysklad.remap_1_2.entities.Assortment;
import ru.moysklad.remap_1_2.entities.Attribute;
import ru.moysklad.remap_1_2.entities.Barcode;
import ru.moysklad.remap_1_2.entities.Currency;
import ru.moysklad.remap_1_2.entities.DocumentAttribute;
import ru.moysklad.remap_1_2.entities.DocumentTemplate;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.entities.Publication;
import ru.moysklad.remap_1_2.entities.RetailStore;
import ru.moysklad.remap_1_2.entities.Template;
import ru.moysklad.remap_1_2.entities.agents.Agent;
import ru.moysklad.remap_1_2.entities.discounts.Discount;
import ru.moysklad.remap_1_2.entities.documents.DocumentEntity;
import ru.moysklad.remap_1_2.entities.documents.markers.FinanceDocumentMarker;
import ru.moysklad.remap_1_2.entities.documents.markers.FinanceInDocumentMarker;
import ru.moysklad.remap_1_2.entities.documents.markers.FinanceOutDocumentMarker;
import ru.moysklad.remap_1_2.entities.notifications.Notification;
import ru.moysklad.remap_1_2.entities.notifications.NotificationExchange;
import ru.moysklad.remap_1_2.entities.notifications.NotificationSubscription;
import ru.moysklad.remap_1_2.entities.products.markers.ConsignmentParentMarker;
import ru.moysklad.remap_1_2.entities.products.markers.ProductAttributeMarker;
import ru.moysklad.remap_1_2.entities.products.markers.ProductMarker;
import ru.moysklad.remap_1_2.entities.products.markers.SingleProductMarker;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.responses.metadata.CompanySettingsMetadata;
import ru.moysklad.remap_1_2.utils.NoAuthRedirectStrategy;
import ru.moysklad.remap_1_2.utils.json.AgentDeserializer;
import ru.moysklad.remap_1_2.utils.json.AttributeSerializer;
import ru.moysklad.remap_1_2.utils.json.CustomEntityMetadataDeserializer;
import ru.moysklad.remap_1_2.utils.json.DiscountDeserializer;
import ru.moysklad.remap_1_2.utils.json.DocumentAttributeSerializer;
import ru.moysklad.remap_1_2.utils.json.DocumentEntitySerializer;
import ru.moysklad.remap_1_2.utils.json.EnumSwitchCaseSerializer;
import ru.moysklad.remap_1_2.utils.json.FinanceDocumentMarkerSerializer;
import ru.moysklad.remap_1_2.utils.json.ListEntityDeserializer;
import ru.moysklad.remap_1_2.utils.json.LocalDateTimeSerializer;
import ru.moysklad.remap_1_2.utils.json.NotificationDeserializer;
import ru.moysklad.remap_1_2.utils.json.ProductAttributeMarkerSerializer;
import ru.moysklad.remap_1_2.utils.json.ProductMarkerSerializer;

public final class ApiClient {
    private final String host;
    private String login;
    private String password;
    private String token;
    private CloseableHttpClient client;
    private boolean prettyPrintJson = false;
    private boolean pricePrecision = false;
    private boolean withoutWebhookContent = false;

    public ApiClient(String host, boolean forceHttps, String login, String password) {
        this(host, forceHttps, login, password, ApiClient.createHttpClient());
    }

    public ApiClient(String host, boolean forceHttps, String login, String password, CloseableHttpClient client) {
        if (host == null || host.trim().isEmpty()) {
            throw new IllegalArgumentException("\u0410\u0434\u0440\u0435\u0441 \u0445\u043e\u0441\u0442\u0430 API \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c \u0438\u043b\u0438 null!");
        }
        host = host.trim();
        while (host.endsWith("/")) {
            host = host.substring(0, host.lastIndexOf("/"));
        }
        if (forceHttps) {
            if (host.startsWith("http://")) {
                host = host.replace("http://", "https://");
            } else if (!host.startsWith("https://")) {
                host = "https://" + host;
            }
        } else if (!host.startsWith("https://") && !host.startsWith("http://")) {
            host = "http://" + host;
        }
        this.host = host;
        this.client = client;
        this.setCredentials(login, password);
    }

    public static ApiClient createWithBearerToken(String host, boolean forceHttps, String token, CloseableHttpClient client) {
        ApiClient apiClient = new ApiClient(host, forceHttps, null, null, client);
        apiClient.setToken(token);
        return apiClient;
    }

    public static ApiClient createWithBearerToken(String host, boolean forceHttps, String token) {
        return ApiClient.createWithBearerToken(host, forceHttps, token, ApiClient.createHttpClient());
    }

    private static CloseableHttpClient createHttpClient() {
        return HttpClients.custom().setRedirectStrategy((RedirectStrategy)new NoAuthRedirectStrategy()).build();
    }

    public void setCredentials(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setHttpClient(CloseableHttpClient client) {
        this.client = client;
    }

    public EntityClient entity() {
        return new EntityClient(this);
    }

    public NotificationClient notification() {
        return new NotificationClient(this);
    }

    public static Gson createGson() {
        return ApiClient.createGson(false);
    }

    public static Gson createGson(boolean prettyPrinting) {
        GsonBuilder gb = new GsonBuilder();
        if (prettyPrinting) {
            gb.setPrettyPrinting();
        }
        ProductAttributeMarkerSerializer pams = new ProductAttributeMarkerSerializer();
        gb.registerTypeAdapter(ProductAttributeMarker.class, (Object)pams);
        ProductMarkerSerializer pmse = new ProductMarkerSerializer();
        gb.registerTypeAdapter(ProductMarker.class, (Object)pmse);
        gb.registerTypeAdapter(SingleProductMarker.class, (Object)pmse);
        gb.registerTypeAdapter(ConsignmentParentMarker.class, (Object)pmse);
        gb.registerTypeAdapter(Assortment.class, (Object)pmse);
        FinanceDocumentMarkerSerializer fdms = new FinanceDocumentMarkerSerializer();
        gb.registerTypeAdapter(FinanceDocumentMarker.class, (Object)fdms);
        gb.registerTypeAdapter(FinanceInDocumentMarker.class, (Object)fdms);
        gb.registerTypeAdapter(FinanceOutDocumentMarker.class, (Object)fdms);
        gb.registerTypeAdapter(DocumentEntity.class, (Object)new DocumentEntitySerializer());
        gb.registerTypeAdapter(Agent.class, (Object)new AgentDeserializer());
        gb.registerTypeAdapter(Attribute.class, (Object)new AttributeSerializer());
        gb.registerTypeAdapter(DocumentAttribute.class, (Object)new DocumentAttributeSerializer());
        gb.registerTypeAdapter(Currency.MultiplicityType.class, (Object)new Currency.MultiplicityType.Serializer());
        gb.registerTypeAdapter(Discount.class, (Object)new DiscountDeserializer());
        gb.registerTypeAdapter(ListEntity.class, (Object)new ListEntityDeserializer());
        gb.registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer());
        gb.registerTypeAdapter(CompanySettingsMetadata.CustomEntityMetadata.class, (Object)new CustomEntityMetadataDeserializer());
        gb.registerTypeAdapter(Barcode.class, (Object)new Barcode.Serializer());
        gb.registerTypeAdapter(DocumentTemplate.class, (Object)new DocumentTemplate.Serializer());
        gb.registerTypeAdapter(Meta.Type.class, (Object)new Meta.Type.Serializer());
        gb.registerTypeAdapter(Template.class, (Object)new Template.Deserializer());
        gb.registerTypeAdapter(Publication.class, (Object)new Publication.Deserializer());
        gb.registerTypeAdapter(NotificationExchange.TaskType.class, new EnumSwitchCaseSerializer());
        gb.registerTypeAdapter(NotificationExchange.TaskState.class, new EnumSwitchCaseSerializer());
        gb.registerTypeAdapter(Notification.class, (Object)new NotificationDeserializer());
        gb.registerTypeAdapter(NotificationSubscription.Channel.class, new EnumSwitchCaseSerializer());
        gb.registerTypeAdapter(RetailStore.PriorityOfdSend.class, new EnumSwitchCaseSerializer());
        return gb.create();
    }

    public ApiClient prettyPrintJson() {
        return this.prettyPrintJson(true);
    }

    public ApiClient prettyPrintJson(boolean value) {
        this.prettyPrintJson = value;
        return this;
    }

    public ApiClient precision() {
        return this.precision(true);
    }

    public ApiClient precision(boolean value) {
        this.pricePrecision = value;
        return this;
    }

    public ApiClient withoutWebhookContent() {
        return this.withoutWebhookContent(true);
    }

    public ApiClient withoutWebhookContent(boolean without) {
        this.withoutWebhookContent = without;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public boolean isPrettyPrintJson() {
        return this.prettyPrintJson;
    }

    public boolean isPricePrecision() {
        return this.pricePrecision;
    }

    public boolean isWithoutWebhookContent() {
        return this.withoutWebhookContent;
    }
}

