/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import ru.moysklad.remap_1_2.entities.Consignment;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.ProductFolder;
import ru.moysklad.remap_1_2.entities.products.Bundle;
import ru.moysklad.remap_1_2.entities.products.Product;
import ru.moysklad.remap_1_2.entities.products.Service;
import ru.moysklad.remap_1_2.entities.products.Variant;
import ru.moysklad.remap_1_2.entities.products.markers.ProductAttributeMarker;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class ProductAttributeMarkerSerializer
implements JsonSerializer<ProductAttributeMarker>,
JsonDeserializer<ProductAttributeMarker> {
    private final Gson gson = JsonUtils.createGsonWithMetaAdapter();

    public ProductAttributeMarker deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
        MetaEntity me = (MetaEntity)this.gson.fromJson(json, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException("Can't parse field 'product': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException("Can't parse field 'product': meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case PRODUCT_FOLDER: {
                return (ProductAttributeMarker)context.deserialize(json, ProductFolder.class);
            }
            case PRODUCT: {
                return (ProductAttributeMarker)context.deserialize(json, Product.class);
            }
            case SERVICE: {
                return (ProductAttributeMarker)context.deserialize(json, Service.class);
            }
            case BUNDLE: {
                return (ProductAttributeMarker)context.deserialize(json, Bundle.class);
            }
            case VARIANT: {
                return (ProductAttributeMarker)context.deserialize(json, Variant.class);
            }
            case CONSIGNMENT: {
                return (ProductAttributeMarker)context.deserialize(json, Consignment.class);
            }
        }
        throw new JsonParseException("Can't parse field 'product': meta.type must be one of [product, service, bundle, variant, consignment, productfolder]");
    }

    public JsonElement serialize(ProductAttributeMarker resource, Type type, JsonSerializationContext context) {
        return context.serialize((Object)resource);
    }
}

