/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import ru.moysklad.remap_1_2.entities.Contract;
import ru.moysklad.remap_1_2.entities.CustomEntityElement;
import ru.moysklad.remap_1_2.entities.DocumentAttribute;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.entities.Project;
import ru.moysklad.remap_1_2.entities.Store;
import ru.moysklad.remap_1_2.entities.agents.Agent;
import ru.moysklad.remap_1_2.entities.products.markers.ProductAttributeMarker;
import ru.moysklad.remap_1_2.utils.MetaHrefUtils;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class DocumentAttributeSerializer
implements JsonSerializer<DocumentAttribute>,
JsonDeserializer<DocumentAttribute> {
    private final Gson gson = JsonUtils.createGsonWithMetaAdapter();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public JsonElement serialize(DocumentAttribute src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject je = null;
        if (src.getType() != null) {
            switch (src.getType()) {
                case timeValue: {
                    if (src.getValue() == null) break;
                    if (src.getValue() instanceof LocalDateTime) {
                        src.setValue(context.serialize((Object)((LocalDateTime)src.getValue()).format(this.formatter)));
                        break;
                    }
                    if (src.getValue() instanceof LocalDate) {
                        src.setValue(context.serialize((Object)((LocalDate)src.getValue()).format(this.formatter)));
                        break;
                    }
                    throw new IllegalArgumentException("\u041d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u0434\u0430\u043d\u043d\u044b\u0445 \u0434\u043b\u044f \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u043b\u044f \u0441 \u0442\u0438\u043f\u043e\u043c 'time': " + src.getValue().getClass().getSimpleName());
                }
            }
            je = this.gson.toJsonTree((Object)src, DocumentAttribute.class);
        } else if (src.getEntityType() != null) {
            JsonObject jo = je = this.gson.toJsonTree((Object)src, DocumentAttribute.class).getAsJsonObject();
            jo.add("type", jo.get("entityType"));
            jo.remove("entityType");
        }
        return je;
    }

    public DocumentAttribute deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jo = this.gson.toJsonTree((Object)json).getAsJsonObject();
        if (!jo.has("type")) {
            throw new IllegalArgumentException("\u0412 \u043f\u0440\u0438\u0448\u0435\u0434\u0448\u0435\u0439 \u0441\u0443\u0449\u043d\u043e\u0441\u0442\u0438 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u043d\u0435\u0442 \u043f\u043e\u043b\u044f 'type'!");
        }
        String attrType = jo.get("type").getAsString();
        try {
            Meta.Type t = Meta.Type.find(attrType);
            jo.remove("type");
            jo.add("entityType", (JsonElement)new JsonPrimitive(t.getApiName()));
        }
        catch (IllegalArgumentException t) {
            // empty catch block
        }
        DocumentAttribute ae = (DocumentAttribute)this.gson.fromJson((JsonElement)jo, DocumentAttribute.class);
        if (ae.getType() != null && ae.getValue() != null) {
            switch (ae.getType()) {
                case longValue: {
                    ae.setValue(((Double)ae.getValue()).longValue());
                    break;
                }
                case timeValue: {
                    ae.setValue(LocalDateTime.parse(String.valueOf(ae.getValue()), this.formatter));
                }
            }
        } else if (ae.getEntityType() != null) {
            switch (ae.getEntityType()) {
                case COUNTERPARTY: 
                case ORGANIZATION: 
                case EMPLOYEE: {
                    ae.setValue(context.deserialize(jo.get("value"), Agent.class));
                    break;
                }
                case PRODUCT: 
                case BUNDLE: 
                case SERVICE: {
                    ae.setValue(context.deserialize(jo.get("value"), ProductAttributeMarker.class));
                    break;
                }
                case CONTRACT: {
                    ae.setValue(context.deserialize(jo.get("value"), Contract.class));
                    break;
                }
                case PROJECT: {
                    ae.setValue(context.deserialize(jo.get("value"), Project.class));
                    break;
                }
                case STORE: {
                    ae.setValue(context.deserialize(jo.get("value"), Store.class));
                    break;
                }
                case CUSTOM_ENTITY: {
                    CustomEntityElement customEntity = (CustomEntityElement)context.deserialize(jo.get("value"), CustomEntityElement.class);
                    if (customEntity != null) {
                        customEntity.setCustomDictionaryId(MetaHrefUtils.getCustomDictionaryIdFromHref(customEntity.getMeta().getHref()));
                    }
                    ae.setValue(customEntity);
                }
            }
        }
        return ae;
    }
}

