/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import ru.moysklad.remap_1_2.clients.EntityClient;
import ru.moysklad.remap_1_2.clients.NotificationClient;
import ru.moysklad.remap_1_2.entities.Assortment;
import ru.moysklad.remap_1_2.entities.Attribute;
import ru.moysklad.remap_1_2.entities.Barcode;
import ru.moysklad.remap_1_2.entities.Currency;
import ru.moysklad.remap_1_2.entities.DocumentAttribute;
import ru.moysklad.remap_1_2.entities.DocumentTemplate;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.entities.Publication;
import ru.moysklad.remap_1_2.entities.RetailStore;
import ru.moysklad.remap_1_2.entities.Template;
import ru.moysklad.remap_1_2.entities.agents.Agent;
import ru.moysklad.remap_1_2.entities.discounts.Discount;
import ru.moysklad.remap_1_2.entities.documents.DocumentEntity;
import ru.moysklad.remap_1_2.entities.documents.markers.FinanceDocumentMarker;
import ru.moysklad.remap_1_2.entities.documents.markers.FinanceInDocumentMarker;
import ru.moysklad.remap_1_2.entities.documents.markers.FinanceOutDocumentMarker;
import ru.moysklad.remap_1_2.entities.notifications.Notification;
import ru.moysklad.remap_1_2.entities.notifications.NotificationExchange;
import ru.moysklad.remap_1_2.entities.notifications.NotificationSubscription;
import ru.moysklad.remap_1_2.entities.products.markers.ConsignmentParentMarker;
import ru.moysklad.remap_1_2.entities.products.markers.ProductAttributeMarker;
import ru.moysklad.remap_1_2.entities.products.markers.ProductMarker;
import ru.moysklad.remap_1_2.entities.products.markers.SingleProductMarker;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.responses.metadata.CompanySettingsMetadata;
import ru.moysklad.remap_1_2.utils.NoAuthRedirectStrategy;
import ru.moysklad.remap_1_2.utils.json.AgentDeserializer;
import ru.moysklad.remap_1_2.utils.json.AssortmentDeserializer;
import ru.moysklad.remap_1_2.utils.json.AttributeDeserializer;
import ru.moysklad.remap_1_2.utils.json.AttributeSerializer;
import ru.moysklad.remap_1_2.utils.json.ConsignmentParentMarkerDeserializer;
import ru.moysklad.remap_1_2.utils.json.CustomEntityMetadataDeserializer;
import ru.moysklad.remap_1_2.utils.json.DiscountDeserializer;
import ru.moysklad.remap_1_2.utils.json.DocumentAttributeDeserializer;
import ru.moysklad.remap_1_2.utils.json.DocumentAttributeSerializer;
import ru.moysklad.remap_1_2.utils.json.DocumentEntityDeserializer;
import ru.moysklad.remap_1_2.utils.json.EnumSwitchCaseDeserializer;
import ru.moysklad.remap_1_2.utils.json.EnumSwitchCaseSerializer;
import ru.moysklad.remap_1_2.utils.json.FinanceDocumentMarkerDeserializer;
import ru.moysklad.remap_1_2.utils.json.FinanceInDocumentMarkerDeserializer;
import ru.moysklad.remap_1_2.utils.json.FinanceOutDocumentMarkerDeserializer;
import ru.moysklad.remap_1_2.utils.json.ListEntityDeserializer;
import ru.moysklad.remap_1_2.utils.json.LocalDateTimeDeserializer;
import ru.moysklad.remap_1_2.utils.json.LocalDateTimeSerializer;
import ru.moysklad.remap_1_2.utils.json.NotificationDeserializer;
import ru.moysklad.remap_1_2.utils.json.OptionalEmptyAsNullSerializer;
import ru.moysklad.remap_1_2.utils.json.ProductAttributeMarkerDeserializer;
import ru.moysklad.remap_1_2.utils.json.ProductMarkerDeserializer;
import ru.moysklad.remap_1_2.utils.json.SingleProductMarkerDeserializer;

public final class ApiClient {
    private final String host;
    private String login;
    private String password;
    private String token;
    private CloseableHttpClient client;
    private boolean prettyPrintJson = false;
    private boolean pricePrecision = false;
    private boolean withoutWebhookContent = false;

    public ApiClient(String host, boolean forceHttps, String login, String password) {
        this(host, forceHttps, login, password, ApiClient.createHttpClient());
    }

    public ApiClient(String host, boolean forceHttps, String login, String password, CloseableHttpClient client) {
        if (host == null || host.trim().isEmpty()) {
            throw new IllegalArgumentException("\u0410\u0434\u0440\u0435\u0441 \u0445\u043e\u0441\u0442\u0430 API \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c \u0438\u043b\u0438 null!");
        }
        host = host.trim();
        while (host.endsWith("/")) {
            host = host.substring(0, host.lastIndexOf("/"));
        }
        if (forceHttps) {
            if (host.startsWith("http://")) {
                host = host.replace("http://", "https://");
            } else if (!host.startsWith("https://")) {
                host = "https://" + host;
            }
        } else if (!host.startsWith("https://") && !host.startsWith("http://")) {
            host = "http://" + host;
        }
        this.host = host;
        this.client = client;
        this.setCredentials(login, password);
    }

    public static ApiClient createWithBearerToken(String host, boolean forceHttps, String token, CloseableHttpClient client) {
        ApiClient apiClient = new ApiClient(host, forceHttps, null, null, client);
        apiClient.setToken(token);
        return apiClient;
    }

    public static ApiClient createWithBearerToken(String host, boolean forceHttps, String token) {
        return ApiClient.createWithBearerToken(host, forceHttps, token, ApiClient.createHttpClient());
    }

    private static CloseableHttpClient createHttpClient() {
        return HttpClients.custom().setRedirectStrategy((RedirectStrategy)new NoAuthRedirectStrategy()).build();
    }

    public void setCredentials(String login, String password) {
        this.login = login;
        this.password = password;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setHttpClient(CloseableHttpClient client) {
        this.client = client;
    }

    public EntityClient entity() {
        return new EntityClient(this);
    }

    public NotificationClient notification() {
        return new NotificationClient(this);
    }

    public static ObjectMapper createObjectMapper() {
        return ApiClient.createObjectMapper(false);
    }

    public static ObjectMapper createObjectMapper(boolean prettyPrinting) {
        ObjectMapper objectMapper = new ObjectMapper();
        if (prettyPrinting) {
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        }
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(ProductAttributeMarker.class, (JsonDeserializer)new ProductAttributeMarkerDeserializer());
        module.addDeserializer(Assortment.class, (JsonDeserializer)new AssortmentDeserializer());
        module.addDeserializer(ProductMarker.class, (JsonDeserializer)new ProductMarkerDeserializer());
        module.addDeserializer(SingleProductMarker.class, (JsonDeserializer)new SingleProductMarkerDeserializer());
        module.addDeserializer(ConsignmentParentMarker.class, (JsonDeserializer)new ConsignmentParentMarkerDeserializer());
        module.addDeserializer(FinanceDocumentMarker.class, (JsonDeserializer)new FinanceDocumentMarkerDeserializer());
        module.addDeserializer(FinanceOutDocumentMarker.class, (JsonDeserializer)new FinanceOutDocumentMarkerDeserializer());
        module.addDeserializer(FinanceInDocumentMarker.class, (JsonDeserializer)new FinanceInDocumentMarkerDeserializer());
        module.addDeserializer(DocumentEntity.class, (JsonDeserializer)new DocumentEntityDeserializer());
        module.addDeserializer(Agent.class, (JsonDeserializer)new AgentDeserializer());
        module.addSerializer(Attribute.class, (JsonSerializer)new AttributeSerializer());
        module.addDeserializer(Attribute.class, (JsonDeserializer)new AttributeDeserializer());
        module.addSerializer(DocumentAttribute.class, (JsonSerializer)new DocumentAttributeSerializer());
        module.addDeserializer(DocumentAttribute.class, (JsonDeserializer)new DocumentAttributeDeserializer());
        module.addSerializer(Currency.MultiplicityType.class, (JsonSerializer)new Currency.MultiplicityType.Serializer());
        module.addDeserializer(Currency.MultiplicityType.class, (JsonDeserializer)new Currency.MultiplicityType.Deserializer());
        module.addDeserializer(Discount.class, (JsonDeserializer)new DiscountDeserializer());
        module.addDeserializer(ListEntity.class, (JsonDeserializer)new ListEntityDeserializer());
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer());
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        module.addDeserializer(CompanySettingsMetadata.CustomEntityMetadata.class, (JsonDeserializer)new CustomEntityMetadataDeserializer());
        module.addSerializer(Barcode.class, (JsonSerializer)new Barcode.Serializer());
        module.addDeserializer(Barcode.class, (JsonDeserializer)new Barcode.Deserializer());
        module.addSerializer(DocumentTemplate.class, (JsonSerializer)new DocumentTemplate.Serializer());
        module.addSerializer(Meta.Type.class, (JsonSerializer)new Meta.Type.Serializer());
        module.addDeserializer(Meta.Type.class, (JsonDeserializer)new Meta.Type.Deserializer());
        module.addDeserializer(Template.class, (JsonDeserializer)new Template.Deserializer());
        module.addDeserializer(Publication.class, (JsonDeserializer)new Publication.Deserializer());
        module.addSerializer(NotificationExchange.TaskType.class, new EnumSwitchCaseSerializer<NotificationExchange.TaskType>(NotificationExchange.TaskType.class));
        module.addDeserializer(NotificationExchange.TaskType.class, new EnumSwitchCaseDeserializer<NotificationExchange.TaskType>(NotificationExchange.TaskType.class));
        module.addSerializer(NotificationExchange.TaskState.class, new EnumSwitchCaseSerializer<NotificationExchange.TaskState>(NotificationExchange.TaskState.class));
        module.addDeserializer(NotificationExchange.TaskState.class, new EnumSwitchCaseDeserializer<NotificationExchange.TaskState>(NotificationExchange.TaskState.class));
        module.addDeserializer(Notification.class, (JsonDeserializer)new NotificationDeserializer());
        module.addSerializer(NotificationSubscription.Channel.class, new EnumSwitchCaseSerializer<NotificationSubscription.Channel>(NotificationSubscription.Channel.class));
        module.addDeserializer(NotificationSubscription.Channel.class, new EnumSwitchCaseDeserializer<NotificationSubscription.Channel>(NotificationSubscription.Channel.class));
        module.addSerializer(RetailStore.PriorityOfdSend.class, new EnumSwitchCaseSerializer<RetailStore.PriorityOfdSend>(RetailStore.PriorityOfdSend.class));
        module.addDeserializer(RetailStore.PriorityOfdSend.class, new EnumSwitchCaseDeserializer<RetailStore.PriorityOfdSend>(RetailStore.PriorityOfdSend.class));
        module.addSerializer(Optional.class, (JsonSerializer)new OptionalEmptyAsNullSerializer());
        objectMapper.registerModule((Module)module);
        return objectMapper;
    }

    public ApiClient prettyPrintJson() {
        return this.prettyPrintJson(true);
    }

    public ApiClient prettyPrintJson(boolean value) {
        this.prettyPrintJson = value;
        return this;
    }

    public ApiClient precision() {
        return this.precision(true);
    }

    public ApiClient precision(boolean value) {
        this.pricePrecision = value;
        return this;
    }

    public ApiClient withoutWebhookContent() {
        return this.withoutWebhookContent(true);
    }

    public ApiClient withoutWebhookContent(boolean without) {
        this.withoutWebhookContent = without;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public boolean isPrettyPrintJson() {
        return this.prettyPrintJson;
    }

    public boolean isPricePrecision() {
        return this.pricePrecision;
    }

    public boolean isWithoutWebhookContent() {
        return this.withoutWebhookContent;
    }
}

