/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import ru.moysklad.remap_1_2.entities.Attribute;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class AttributeSerializer
extends JsonSerializer<Attribute> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public void serialize(Attribute src, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (src.getType() != null) {
            switch (src.getType()) {
                case timeValue: {
                    if (src.getValue() == null) break;
                    if (src.getValue() instanceof LocalDateTime) {
                        src.setValue(((LocalDateTime)src.getValue()).format(this.formatter));
                        break;
                    }
                    if (src.getValue() instanceof LocalDate) {
                        src.setValue(((LocalDate)src.getValue()).format(this.formatter));
                        break;
                    }
                    throw new IllegalArgumentException("Unsupported type for 'time' field: " + src.getValue().getClass().getSimpleName());
                }
            }
            TypeFactory typeFactory = TypeFactory.defaultInstance();
            JavaType javaType = typeFactory.constructType(Attribute.class);
            BeanSerializerFactory.instance.createSerializer(serializers, javaType).serialize((Object)src, gen, serializers);
        } else if (src.getEntityType() != null) {
            JsonNode node = this.objectMapper.valueToTree((Object)src);
            ObjectNode objectNode = (ObjectNode)node;
            JsonNode entityTypeNode = objectNode.get("entityType");
            objectNode.set("type", entityTypeNode);
            objectNode.remove("entityType");
            ((ObjectMapper)gen.getCodec()).writeTree(gen, node);
        }
    }
}

