/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.documents.CashOut;
import ru.moysklad.remap_1_2.entities.documents.PaymentOut;
import ru.moysklad.remap_1_2.entities.documents.markers.FinanceOutDocumentMarker;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class FinanceOutDocumentMarkerDeserializer
extends JsonDeserializer<FinanceOutDocumentMarker> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();

    public FinanceOutDocumentMarker deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        MetaEntity me = (MetaEntity)this.objectMapper.treeToValue((TreeNode)node, MetaEntity.class);
        if (me.getMeta() == null) {
            throw new JsonParseException(p, "Can't parse field 'payments': meta is null");
        }
        if (me.getMeta().getType() == null) {
            throw new JsonParseException(p, "Can't parse field 'payments': meta.type is null");
        }
        switch (me.getMeta().getType()) {
            case CASH_OUT: {
                return (FinanceOutDocumentMarker)this.objectMapper.treeToValue((TreeNode)node, CashOut.class);
            }
            case PAYMENT_OUT: {
                return (FinanceOutDocumentMarker)this.objectMapper.treeToValue((TreeNode)node, PaymentOut.class);
            }
        }
        throw new JsonParseException(p, "Can't parse field 'payments': meta.type must be one of [cashin, cashout, paymentin, paymentout]");
    }
}

