/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.clients.endpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import ru.moysklad.remap_1_2.clients.endpoints.ApiEndpoint;
import ru.moysklad.remap_1_2.clients.endpoints.Endpoint;
import ru.moysklad.remap_1_2.entities.MetaEntity;
import ru.moysklad.remap_1_2.entities.documents.DocumentEntity;
import ru.moysklad.remap_1_2.entities.documents.DocumentPosition;
import ru.moysklad.remap_1_2.responses.ListEntity;
import ru.moysklad.remap_1_2.utils.ApiClientException;
import ru.moysklad.remap_1_2.utils.HttpRequestExecutor;
import ru.moysklad.remap_1_2.utils.MetaHrefUtils;
import ru.moysklad.remap_1_2.utils.params.ApiParam;

public interface DocumentPositionsEndpoint<T extends DocumentPosition>
extends Endpoint {
    @ApiEndpoint
    default public List<T> createPositions(String documentId, List<T> updatedEntities) throws IOException, ApiClientException {
        updatedEntities = updatedEntities.stream().map(e -> MetaHrefUtils.fillMeta(e, this.api().getHost() + "/api/remap/1.2")).collect(Collectors.toList());
        List<DocumentPosition> responseEntity = HttpRequestExecutor.path(this.api(), this.path() + documentId + "/positions/").body(updatedEntities).postList(this.documentPositionClass());
        for (int i = 0; i < responseEntity.size(); ++i) {
            updatedEntities.set(i, responseEntity.get(i));
        }
        return updatedEntities;
    }

    @ApiEndpoint
    default public List<T> createPositions(DocumentEntity document, List<T> updatedEntities) throws IOException, ApiClientException {
        return this.createPositions(document.getId(), updatedEntities);
    }

    @ApiEndpoint
    default public T createPosition(String documentId, T updatedEntity) throws IOException, ApiClientException {
        ArrayList<T> positionList = new ArrayList<T>(Collections.singletonList(updatedEntity));
        List<T> newPosition = this.createPositions(documentId, positionList);
        updatedEntity.set((DocumentPosition)((DocumentPosition)newPosition.get(0)));
        return (T)updatedEntity;
    }

    @ApiEndpoint
    default public T createPosition(DocumentEntity document, T updatedEntity) throws IOException, ApiClientException {
        return this.createPosition(document.getId(), updatedEntity);
    }

    @ApiEndpoint
    default public ListEntity<T> getPositions(String documentId, ApiParam ... params) throws IOException, ApiClientException {
        return HttpRequestExecutor.path(this.api(), this.path() + documentId + "/positions").apiParams(params).list(this.documentPositionClass());
    }

    @ApiEndpoint
    default public ListEntity<T> getPositions(DocumentEntity document, ApiParam ... params) throws IOException, ApiClientException {
        return this.getPositions(document.getId(), params);
    }

    @ApiEndpoint
    default public T getPosition(String documentId, String positionId, ApiParam ... params) throws IOException, ApiClientException {
        return (T)HttpRequestExecutor.path(this.api(), this.path() + documentId + "/positions/" + positionId).apiParams(params).get(this.documentPositionClass());
    }

    @ApiEndpoint
    default public T getPosition(DocumentEntity document, String positionId, ApiParam ... params) throws IOException, ApiClientException {
        return this.getPosition(document.getId(), positionId, params);
    }

    @ApiEndpoint
    default public void updatePosition(String documentId, String positionId, T updatedEntity) throws IOException, ApiClientException {
        MetaHrefUtils.fillMeta(updatedEntity, this.api().getHost() + "/api/remap/1.2");
        DocumentPosition responseEntity = HttpRequestExecutor.path(this.api(), this.path() + documentId + "/positions/" + positionId).body(updatedEntity).put(DocumentPosition.class);
        updatedEntity.set((DocumentPosition)responseEntity);
    }

    @ApiEndpoint
    default public void updatePosition(DocumentEntity document, String positionId, T updatedEntity) throws IOException, ApiClientException {
        this.updatePosition(document.getId(), positionId, updatedEntity);
    }

    @ApiEndpoint
    default public void updatePosition(DocumentEntity document, T position, T updatedEntity) throws IOException, ApiClientException {
        this.updatePosition(document, (T)((MetaEntity)position).getId(), updatedEntity);
    }

    @ApiEndpoint
    default public void updatePosition(DocumentEntity document, T position) throws IOException, ApiClientException {
        this.updatePosition(document, position, position);
    }

    @ApiEndpoint
    default public void deletePosition(String documentId, String positionId) throws IOException, ApiClientException {
        HttpRequestExecutor.path(this.api(), this.path() + documentId + "/positions/" + positionId).delete();
    }

    @ApiEndpoint
    default public void deletePosition(DocumentEntity document, String positionId) throws IOException, ApiClientException {
        this.deletePosition(document.getId(), positionId);
    }

    @ApiEndpoint
    default public void deletePosition(DocumentEntity document, T position) throws IOException, ApiClientException {
        this.deletePosition(document, ((MetaEntity)position).getId());
    }

    public Class<? extends DocumentPosition> documentPositionClass();
}

