/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.utils.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import ru.moysklad.remap_1_2.entities.CustomEntity;
import ru.moysklad.remap_1_2.entities.Meta;
import ru.moysklad.remap_1_2.responses.metadata.CompanySettingsMetadata;
import ru.moysklad.remap_1_2.utils.json.JsonUtils;

public class CustomEntityMetadataDeserializer
extends JsonDeserializer<CompanySettingsMetadata.CustomEntityMetadata> {
    private final ObjectMapper objectMapper = JsonUtils.createObjectMapperWithMetaAdapter();

    public CompanySettingsMetadata.CustomEntityMetadata deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        CompanySettingsMetadata.CustomEntityMetadata cem = new CompanySettingsMetadata.CustomEntityMetadata();
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        cem.setMeta((Meta)this.objectMapper.treeToValue((TreeNode)node.get("meta"), Meta.class));
        String name = node.get("name").asText();
        cem.setName(name);
        cem.setCreateShared(node.get("createShared").asBoolean());
        CustomEntity entityMeta = new CustomEntity();
        entityMeta.setName(name);
        entityMeta.setMeta((Meta)this.objectMapper.treeToValue((TreeNode)node.get("entityMeta"), Meta.class));
        if (entityMeta.getMeta().getHref() == null) {
            throw new JsonParseException(p, "Can't parse field 'entityMeta': href is null");
        }
        String[] hrefSplit = entityMeta.getMeta().getHref().split("/");
        entityMeta.setId(hrefSplit[hrefSplit.length - 1]);
        cem.setEntityMeta(entityMeta);
        return cem;
    }
}

