/*
 * Decompiled with CFR 0.152.
 */
package ru.moysklad.remap_1_2.entities;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import ru.moysklad.remap_1_2.entities.documents.DocumentEntity;

public class DocumentTemplate {
    private String documentType;
    private DocumentEntity document;
    private List<DocumentEntity> documents;

    public String getDocumentType() {
        return this.documentType;
    }

    public DocumentEntity getDocument() {
        return this.document;
    }

    public List<DocumentEntity> getDocuments() {
        return this.documents;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public void setDocument(DocumentEntity document) {
        this.document = document;
    }

    public void setDocuments(List<DocumentEntity> documents) {
        this.documents = documents;
    }

    public static class Serializer
    extends JsonSerializer<DocumentTemplate> {
        public void serialize(DocumentTemplate src, JsonGenerator jsonGenerator, SerializerProvider serializers) throws IOException {
            ObjectMapper objectMapper = (ObjectMapper)jsonGenerator.getCodec();
            ObjectNode serializedDocumentTemplate = objectMapper.createObjectNode();
            if (src.getDocument() != null) {
                ObjectNode element = objectMapper.createObjectNode();
                JsonNode metaNode = objectMapper.valueToTree((Object)src.getDocument().getMeta());
                element.set("meta", metaNode);
                serializedDocumentTemplate.set(src.getDocumentType(), (JsonNode)element);
            } else if (src.getDocuments() != null) {
                ArrayNode metaArray = objectMapper.createArrayNode();
                for (DocumentEntity document : src.getDocuments()) {
                    ObjectNode element = objectMapper.createObjectNode();
                    JsonNode metaNode = objectMapper.valueToTree((Object)document.getMeta());
                    element.set("meta", metaNode);
                    metaArray.add((JsonNode)element);
                }
                serializedDocumentTemplate.set(src.getDocumentType(), (JsonNode)metaArray);
            }
            jsonGenerator.writeTree((TreeNode)serializedDocumentTemplate);
        }
    }
}

